package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  PrincipalOrderingId,
  RoleArn,
  DataSourceId,
  IndexId,
  GroupId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutPrincipalMappingRequest(
    indexId: IndexId,
    dataSourceId: Optional[DataSourceId] = Optional.Absent,
    groupId: GroupId,
    groupMembers: zio.aws.kendra.model.GroupMembers,
    orderingId: Optional[PrincipalOrderingId] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.PutPrincipalMappingRequest = {
    import PutPrincipalMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.PutPrincipalMappingRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        dataSourceId.map(value => DataSourceId.unwrap(value): java.lang.String)
      )(_.dataSourceId)
      .groupId(GroupId.unwrap(groupId): java.lang.String)
      .groupMembers(groupMembers.buildAwsValue())
      .optionallyWith(
        orderingId.map(value =>
          PrincipalOrderingId.unwrap(value): java.lang.Long
        )
      )(_.orderingId)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.PutPrincipalMappingRequest.ReadOnly =
    zio.aws.kendra.model.PutPrincipalMappingRequest.wrap(buildAwsValue())
}
object PutPrincipalMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.PutPrincipalMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.PutPrincipalMappingRequest =
      zio.aws.kendra.model.PutPrincipalMappingRequest(
        indexId,
        dataSourceId.map(value => value),
        groupId,
        groupMembers.asEditable,
        orderingId.map(value => value),
        roleArn.map(value => value)
      )
    def indexId: IndexId
    def dataSourceId: Optional[DataSourceId]
    def groupId: GroupId
    def groupMembers: zio.aws.kendra.model.GroupMembers.ReadOnly
    def orderingId: Optional[PrincipalOrderingId]
    def roleArn: Optional[RoleArn]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getDataSourceId: ZIO[Any, AwsError, DataSourceId] =
      AwsError.unwrapOptionField("dataSourceId", dataSourceId)
    def getGroupId: ZIO[Any, Nothing, GroupId] = ZIO.succeed(groupId)
    def getGroupMembers
        : ZIO[Any, Nothing, zio.aws.kendra.model.GroupMembers.ReadOnly] =
      ZIO.succeed(groupMembers)
    def getOrderingId: ZIO[Any, AwsError, PrincipalOrderingId] =
      AwsError.unwrapOptionField("orderingId", orderingId)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.PutPrincipalMappingRequest
  ) extends zio.aws.kendra.model.PutPrincipalMappingRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val dataSourceId: Optional[DataSourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceId())
      .map(value => zio.aws.kendra.model.primitives.DataSourceId(value))
    override val groupId: GroupId =
      zio.aws.kendra.model.primitives.GroupId(impl.groupId())
    override val groupMembers: zio.aws.kendra.model.GroupMembers.ReadOnly =
      zio.aws.kendra.model.GroupMembers.wrap(impl.groupMembers())
    override val orderingId: Optional[PrincipalOrderingId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orderingId())
        .map(value =>
          zio.aws.kendra.model.primitives.PrincipalOrderingId(value)
        )
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.PutPrincipalMappingRequest
  ): zio.aws.kendra.model.PutPrincipalMappingRequest.ReadOnly = new Wrapper(
    impl
  )
}
