package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{Integer, QueryId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QueryResponse(
    queryId: Optional[QueryId] = Optional.Absent,
    resultItems: Optional[Iterable[zio.aws.kendra.model.QueryResultItem]] =
      Optional.Absent,
    facetResults: Optional[Iterable[zio.aws.kendra.model.FacetResult]] =
      Optional.Absent,
    totalNumberOfResults: Optional[Integer] = Optional.Absent,
    warnings: Optional[Iterable[zio.aws.kendra.model.Warning]] =
      Optional.Absent,
    spellCorrectedQueries: Optional[
      Iterable[zio.aws.kendra.model.SpellCorrectedQuery]
    ] = Optional.Absent,
    featuredResultsItems: Optional[
      Iterable[zio.aws.kendra.model.FeaturedResultsItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.QueryResponse = {
    import QueryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.QueryResponse
      .builder()
      .optionallyWith(
        queryId.map(value => QueryId.unwrap(value): java.lang.String)
      )(_.queryId)
      .optionallyWith(
        resultItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resultItems)
      .optionallyWith(
        facetResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.facetResults)
      .optionallyWith(
        totalNumberOfResults.map(value => value: java.lang.Integer)
      )(_.totalNumberOfResults)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.warnings)
      .optionallyWith(
        spellCorrectedQueries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.spellCorrectedQueries)
      .optionallyWith(
        featuredResultsItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.featuredResultsItems)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.QueryResponse.ReadOnly =
    zio.aws.kendra.model.QueryResponse.wrap(buildAwsValue())
}
object QueryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.QueryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.QueryResponse =
      zio.aws.kendra.model.QueryResponse(
        queryId.map(value => value),
        resultItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        facetResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalNumberOfResults.map(value => value),
        warnings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        spellCorrectedQueries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        featuredResultsItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def queryId: Optional[QueryId]
    def resultItems
        : Optional[List[zio.aws.kendra.model.QueryResultItem.ReadOnly]]
    def facetResults: Optional[List[zio.aws.kendra.model.FacetResult.ReadOnly]]
    def totalNumberOfResults: Optional[Integer]
    def warnings: Optional[List[zio.aws.kendra.model.Warning.ReadOnly]]
    def spellCorrectedQueries
        : Optional[List[zio.aws.kendra.model.SpellCorrectedQuery.ReadOnly]]
    def featuredResultsItems
        : Optional[List[zio.aws.kendra.model.FeaturedResultsItem.ReadOnly]]
    def getQueryId: ZIO[Any, AwsError, QueryId] =
      AwsError.unwrapOptionField("queryId", queryId)
    def getResultItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.QueryResultItem.ReadOnly
    ]] = AwsError.unwrapOptionField("resultItems", resultItems)
    def getFacetResults
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.FacetResult.ReadOnly]] =
      AwsError.unwrapOptionField("facetResults", facetResults)
    def getTotalNumberOfResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalNumberOfResults", totalNumberOfResults)
    def getWarnings
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.Warning.ReadOnly]] =
      AwsError.unwrapOptionField("warnings", warnings)
    def getSpellCorrectedQueries: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.SpellCorrectedQuery.ReadOnly
    ]] =
      AwsError.unwrapOptionField("spellCorrectedQueries", spellCorrectedQueries)
    def getFeaturedResultsItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.FeaturedResultsItem.ReadOnly
    ]] =
      AwsError.unwrapOptionField("featuredResultsItems", featuredResultsItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.QueryResponse
  ) extends zio.aws.kendra.model.QueryResponse.ReadOnly {
    override val queryId: Optional[QueryId] = zio.aws.core.internal
      .optionalFromNullable(impl.queryId())
      .map(value => zio.aws.kendra.model.primitives.QueryId(value))
    override val resultItems
        : Optional[List[zio.aws.kendra.model.QueryResultItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.QueryResultItem.wrap(item)
          }.toList
        )
    override val facetResults
        : Optional[List[zio.aws.kendra.model.FacetResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.facetResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.FacetResult.wrap(item)
          }.toList
        )
    override val totalNumberOfResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalNumberOfResults())
      .map(value => value: Integer)
    override val warnings
        : Optional[List[zio.aws.kendra.model.Warning.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.warnings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.Warning.wrap(item)
          }.toList
        )
    override val spellCorrectedQueries
        : Optional[List[zio.aws.kendra.model.SpellCorrectedQuery.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spellCorrectedQueries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.SpellCorrectedQuery.wrap(item)
          }.toList
        )
    override val featuredResultsItems
        : Optional[List[zio.aws.kendra.model.FeaturedResultsItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featuredResultsItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.FeaturedResultsItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.QueryResponse
  ): zio.aws.kendra.model.QueryResponse.ReadOnly = new Wrapper(impl)
}
