package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait QueryResultType {
  def unwrap: software.amazon.awssdk.services.kendra.model.QueryResultType
}
object QueryResultType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.QueryResultType
  ): zio.aws.kendra.model.QueryResultType = value match {
    case software.amazon.awssdk.services.kendra.model.QueryResultType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.QueryResultType.DOCUMENT =>
      val r = DOCUMENT
      r
    case software.amazon.awssdk.services.kendra.model.QueryResultType.QUESTION_ANSWER =>
      val r = QUESTION_ANSWER
      r
    case software.amazon.awssdk.services.kendra.model.QueryResultType.ANSWER =>
      val r = ANSWER
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.QueryResultType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.QueryResultType =
      software.amazon.awssdk.services.kendra.model.QueryResultType.UNKNOWN_TO_SDK_VERSION
  }
  case object DOCUMENT extends zio.aws.kendra.model.QueryResultType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.QueryResultType =
      software.amazon.awssdk.services.kendra.model.QueryResultType.DOCUMENT
  }
  case object QUESTION_ANSWER extends zio.aws.kendra.model.QueryResultType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.QueryResultType =
      software.amazon.awssdk.services.kendra.model.QueryResultType.QUESTION_ANSWER
  }
  case object ANSWER extends zio.aws.kendra.model.QueryResultType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.QueryResultType =
      software.amazon.awssdk.services.kendra.model.QueryResultType.ANSWER
  }
}
