package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait ReadAccessType {
  def unwrap: software.amazon.awssdk.services.kendra.model.ReadAccessType
}
object ReadAccessType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.ReadAccessType
  ): zio.aws.kendra.model.ReadAccessType = value match {
    case software.amazon.awssdk.services.kendra.model.ReadAccessType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.ReadAccessType.ALLOW =>
      val r = ALLOW
      r
    case software.amazon.awssdk.services.kendra.model.ReadAccessType.DENY =>
      val r = DENY
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.ReadAccessType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ReadAccessType =
      software.amazon.awssdk.services.kendra.model.ReadAccessType.UNKNOWN_TO_SDK_VERSION
  }
  case object ALLOW extends zio.aws.kendra.model.ReadAccessType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ReadAccessType =
      software.amazon.awssdk.services.kendra.model.ReadAccessType.ALLOW
  }
  case object DENY extends zio.aws.kendra.model.ReadAccessType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ReadAccessType =
      software.amazon.awssdk.services.kendra.model.ReadAccessType.DENY
  }
}
