package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.ResultId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RelevanceFeedback(
    resultId: ResultId,
    relevanceValue: zio.aws.kendra.model.RelevanceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.RelevanceFeedback = {
    import RelevanceFeedback.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.RelevanceFeedback
      .builder()
      .resultId(ResultId.unwrap(resultId): java.lang.String)
      .relevanceValue(relevanceValue.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.RelevanceFeedback.ReadOnly =
    zio.aws.kendra.model.RelevanceFeedback.wrap(buildAwsValue())
}
object RelevanceFeedback {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.RelevanceFeedback
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.RelevanceFeedback =
      zio.aws.kendra.model.RelevanceFeedback(resultId, relevanceValue)
    def resultId: ResultId
    def relevanceValue: zio.aws.kendra.model.RelevanceType
    def getResultId: ZIO[Any, Nothing, ResultId] = ZIO.succeed(resultId)
    def getRelevanceValue
        : ZIO[Any, Nothing, zio.aws.kendra.model.RelevanceType] =
      ZIO.succeed(relevanceValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.RelevanceFeedback
  ) extends zio.aws.kendra.model.RelevanceFeedback.ReadOnly {
    override val resultId: ResultId =
      zio.aws.kendra.model.primitives.ResultId(impl.resultId())
    override val relevanceValue: zio.aws.kendra.model.RelevanceType =
      zio.aws.kendra.model.RelevanceType.wrap(impl.relevanceValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.RelevanceFeedback
  ): zio.aws.kendra.model.RelevanceFeedback.ReadOnly = new Wrapper(impl)
}
