package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait RelevanceType {
  def unwrap: software.amazon.awssdk.services.kendra.model.RelevanceType
}
object RelevanceType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.RelevanceType
  ): zio.aws.kendra.model.RelevanceType = value match {
    case software.amazon.awssdk.services.kendra.model.RelevanceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.RelevanceType.RELEVANT =>
      val r = RELEVANT
      r
    case software.amazon.awssdk.services.kendra.model.RelevanceType.NOT_RELEVANT =>
      val r = NOT_RELEVANT
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.RelevanceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.RelevanceType =
      software.amazon.awssdk.services.kendra.model.RelevanceType.UNKNOWN_TO_SDK_VERSION
  }
  case object RELEVANT extends zio.aws.kendra.model.RelevanceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.RelevanceType =
      software.amazon.awssdk.services.kendra.model.RelevanceType.RELEVANT
  }
  case object NOT_RELEVANT extends zio.aws.kendra.model.RelevanceType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.RelevanceType =
      software.amazon.awssdk.services.kendra.model.RelevanceType.NOT_RELEVANT
  }
}
