package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  Integer,
  DocumentAttributeKey,
  QueryText,
  IndexId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RetrieveRequest(
    indexId: IndexId,
    queryText: QueryText,
    attributeFilter: Optional[zio.aws.kendra.model.AttributeFilter] =
      Optional.Absent,
    requestedDocumentAttributes: Optional[Iterable[DocumentAttributeKey]] =
      Optional.Absent,
    documentRelevanceOverrideConfigurations: Optional[
      Iterable[zio.aws.kendra.model.DocumentRelevanceConfiguration]
    ] = Optional.Absent,
    pageNumber: Optional[Integer] = Optional.Absent,
    pageSize: Optional[Integer] = Optional.Absent,
    userContext: Optional[zio.aws.kendra.model.UserContext] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.RetrieveRequest = {
    import RetrieveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.RetrieveRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .queryText(QueryText.unwrap(queryText): java.lang.String)
      .optionallyWith(attributeFilter.map(value => value.buildAwsValue()))(
        _.attributeFilter
      )
      .optionallyWith(
        requestedDocumentAttributes.map(value =>
          value.map { item =>
            DocumentAttributeKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.requestedDocumentAttributes)
      .optionallyWith(
        documentRelevanceOverrideConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentRelevanceOverrideConfigurations)
      .optionallyWith(pageNumber.map(value => value: java.lang.Integer))(
        _.pageNumber
      )
      .optionallyWith(pageSize.map(value => value: java.lang.Integer))(
        _.pageSize
      )
      .optionallyWith(userContext.map(value => value.buildAwsValue()))(
        _.userContext
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.RetrieveRequest.ReadOnly =
    zio.aws.kendra.model.RetrieveRequest.wrap(buildAwsValue())
}
object RetrieveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.RetrieveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.RetrieveRequest =
      zio.aws.kendra.model.RetrieveRequest(
        indexId,
        queryText,
        attributeFilter.map(value => value.asEditable),
        requestedDocumentAttributes.map(value => value),
        documentRelevanceOverrideConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pageNumber.map(value => value),
        pageSize.map(value => value),
        userContext.map(value => value.asEditable)
      )
    def indexId: IndexId
    def queryText: QueryText
    def attributeFilter: Optional[zio.aws.kendra.model.AttributeFilter.ReadOnly]
    def requestedDocumentAttributes: Optional[List[DocumentAttributeKey]]
    def documentRelevanceOverrideConfigurations: Optional[
      List[zio.aws.kendra.model.DocumentRelevanceConfiguration.ReadOnly]
    ]
    def pageNumber: Optional[Integer]
    def pageSize: Optional[Integer]
    def userContext: Optional[zio.aws.kendra.model.UserContext.ReadOnly]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getQueryText: ZIO[Any, Nothing, QueryText] = ZIO.succeed(queryText)
    def getAttributeFilter
        : ZIO[Any, AwsError, zio.aws.kendra.model.AttributeFilter.ReadOnly] =
      AwsError.unwrapOptionField("attributeFilter", attributeFilter)
    def getRequestedDocumentAttributes
        : ZIO[Any, AwsError, List[DocumentAttributeKey]] =
      AwsError.unwrapOptionField(
        "requestedDocumentAttributes",
        requestedDocumentAttributes
      )
    def getDocumentRelevanceOverrideConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DocumentRelevanceConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "documentRelevanceOverrideConfigurations",
      documentRelevanceOverrideConfigurations
    )
    def getPageNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pageNumber", pageNumber)
    def getPageSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getUserContext
        : ZIO[Any, AwsError, zio.aws.kendra.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("userContext", userContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.RetrieveRequest
  ) extends zio.aws.kendra.model.RetrieveRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val queryText: QueryText =
      zio.aws.kendra.model.primitives.QueryText(impl.queryText())
    override val attributeFilter
        : Optional[zio.aws.kendra.model.AttributeFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeFilter())
        .map(value => zio.aws.kendra.model.AttributeFilter.wrap(value))
    override val requestedDocumentAttributes
        : Optional[List[DocumentAttributeKey]] = zio.aws.core.internal
      .optionalFromNullable(impl.requestedDocumentAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives.DocumentAttributeKey(item)
        }.toList
      )
    override val documentRelevanceOverrideConfigurations: Optional[
      List[zio.aws.kendra.model.DocumentRelevanceConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.documentRelevanceOverrideConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DocumentRelevanceConfiguration.wrap(item)
        }.toList
      )
    override val pageNumber: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.pageNumber())
      .map(value => value: Integer)
    override val pageSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => value: Integer)
    override val userContext
        : Optional[zio.aws.kendra.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userContext())
        .map(value => zio.aws.kendra.model.UserContext.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.RetrieveRequest
  ): zio.aws.kendra.model.RetrieveRequest.ReadOnly = new Wrapper(impl)
}
