package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.QueryId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RetrieveResponse(
    queryId: Optional[QueryId] = Optional.Absent,
    resultItems: Optional[Iterable[zio.aws.kendra.model.RetrieveResultItem]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.RetrieveResponse = {
    import RetrieveResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.RetrieveResponse
      .builder()
      .optionallyWith(
        queryId.map(value => QueryId.unwrap(value): java.lang.String)
      )(_.queryId)
      .optionallyWith(
        resultItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resultItems)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.RetrieveResponse.ReadOnly =
    zio.aws.kendra.model.RetrieveResponse.wrap(buildAwsValue())
}
object RetrieveResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.RetrieveResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.RetrieveResponse =
      zio.aws.kendra.model.RetrieveResponse(
        queryId.map(value => value),
        resultItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def queryId: Optional[QueryId]
    def resultItems
        : Optional[List[zio.aws.kendra.model.RetrieveResultItem.ReadOnly]]
    def getQueryId: ZIO[Any, AwsError, QueryId] =
      AwsError.unwrapOptionField("queryId", queryId)
    def getResultItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.RetrieveResultItem.ReadOnly
    ]] = AwsError.unwrapOptionField("resultItems", resultItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.RetrieveResponse
  ) extends zio.aws.kendra.model.RetrieveResponse.ReadOnly {
    override val queryId: Optional[QueryId] = zio.aws.core.internal
      .optionalFromNullable(impl.queryId())
      .map(value => zio.aws.kendra.model.primitives.QueryId(value))
    override val resultItems
        : Optional[List[zio.aws.kendra.model.RetrieveResultItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.RetrieveResultItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.RetrieveResponse
  ): zio.aws.kendra.model.RetrieveResponse.ReadOnly = new Wrapper(impl)
}
