package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ResultId,
  DocumentTitle,
  Url,
  Content,
  DocumentId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RetrieveResultItem(
    id: Optional[ResultId] = Optional.Absent,
    documentId: Optional[DocumentId] = Optional.Absent,
    documentTitle: Optional[DocumentTitle] = Optional.Absent,
    content: Optional[Content] = Optional.Absent,
    documentURI: Optional[Url] = Optional.Absent,
    documentAttributes: Optional[
      Iterable[zio.aws.kendra.model.DocumentAttribute]
    ] = Optional.Absent,
    scoreAttributes: Optional[zio.aws.kendra.model.ScoreAttributes] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.RetrieveResultItem = {
    import RetrieveResultItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.RetrieveResultItem
      .builder()
      .optionallyWith(
        id.map(value => ResultId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        documentId.map(value => DocumentId.unwrap(value): java.lang.String)
      )(_.documentId)
      .optionallyWith(
        documentTitle.map(value =>
          DocumentTitle.unwrap(value): java.lang.String
        )
      )(_.documentTitle)
      .optionallyWith(
        content.map(value => Content.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        documentURI.map(value => Url.unwrap(value): java.lang.String)
      )(_.documentURI)
      .optionallyWith(
        documentAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentAttributes)
      .optionallyWith(scoreAttributes.map(value => value.buildAwsValue()))(
        _.scoreAttributes
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.RetrieveResultItem.ReadOnly =
    zio.aws.kendra.model.RetrieveResultItem.wrap(buildAwsValue())
}
object RetrieveResultItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.RetrieveResultItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.RetrieveResultItem =
      zio.aws.kendra.model.RetrieveResultItem(
        id.map(value => value),
        documentId.map(value => value),
        documentTitle.map(value => value),
        content.map(value => value),
        documentURI.map(value => value),
        documentAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scoreAttributes.map(value => value.asEditable)
      )
    def id: Optional[ResultId]
    def documentId: Optional[DocumentId]
    def documentTitle: Optional[DocumentTitle]
    def content: Optional[Content]
    def documentURI: Optional[Url]
    def documentAttributes
        : Optional[List[zio.aws.kendra.model.DocumentAttribute.ReadOnly]]
    def scoreAttributes: Optional[zio.aws.kendra.model.ScoreAttributes.ReadOnly]
    def getId: ZIO[Any, AwsError, ResultId] =
      AwsError.unwrapOptionField("id", id)
    def getDocumentId: ZIO[Any, AwsError, DocumentId] =
      AwsError.unwrapOptionField("documentId", documentId)
    def getDocumentTitle: ZIO[Any, AwsError, DocumentTitle] =
      AwsError.unwrapOptionField("documentTitle", documentTitle)
    def getContent: ZIO[Any, AwsError, Content] =
      AwsError.unwrapOptionField("content", content)
    def getDocumentURI: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("documentURI", documentURI)
    def getDocumentAttributes: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DocumentAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("documentAttributes", documentAttributes)
    def getScoreAttributes
        : ZIO[Any, AwsError, zio.aws.kendra.model.ScoreAttributes.ReadOnly] =
      AwsError.unwrapOptionField("scoreAttributes", scoreAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.RetrieveResultItem
  ) extends zio.aws.kendra.model.RetrieveResultItem.ReadOnly {
    override val id: Optional[ResultId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.ResultId(value))
    override val documentId: Optional[DocumentId] = zio.aws.core.internal
      .optionalFromNullable(impl.documentId())
      .map(value => zio.aws.kendra.model.primitives.DocumentId(value))
    override val documentTitle: Optional[DocumentTitle] = zio.aws.core.internal
      .optionalFromNullable(impl.documentTitle())
      .map(value => zio.aws.kendra.model.primitives.DocumentTitle(value))
    override val content: Optional[Content] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.kendra.model.primitives.Content(value))
    override val documentURI: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.documentURI())
      .map(value => zio.aws.kendra.model.primitives.Url(value))
    override val documentAttributes
        : Optional[List[zio.aws.kendra.model.DocumentAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.DocumentAttribute.wrap(item)
          }.toList
        )
    override val scoreAttributes
        : Optional[zio.aws.kendra.model.ScoreAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scoreAttributes())
        .map(value => zio.aws.kendra.model.ScoreAttributes.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.RetrieveResultItem
  ): zio.aws.kendra.model.RetrieveResultItem.ReadOnly = new Wrapper(impl)
}
