package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  DataSourceInclusionsExclusionsStringsMember,
  S3BucketName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3DataSourceConfiguration(
    bucketName: S3BucketName,
    inclusionPrefixes: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    inclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    exclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    documentsMetadataConfiguration: Optional[
      zio.aws.kendra.model.DocumentsMetadataConfiguration
    ] = Optional.Absent,
    accessControlListConfiguration: Optional[
      zio.aws.kendra.model.AccessControlListConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.S3DataSourceConfiguration = {
    import S3DataSourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.S3DataSourceConfiguration
      .builder()
      .bucketName(S3BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        inclusionPrefixes.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPrefixes)
      .optionallyWith(
        inclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPatterns)
      .optionallyWith(
        exclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionPatterns)
      .optionallyWith(
        documentsMetadataConfiguration.map(value => value.buildAwsValue())
      )(_.documentsMetadataConfiguration)
      .optionallyWith(
        accessControlListConfiguration.map(value => value.buildAwsValue())
      )(_.accessControlListConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.S3DataSourceConfiguration.ReadOnly =
    zio.aws.kendra.model.S3DataSourceConfiguration.wrap(buildAwsValue())
}
object S3DataSourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.S3DataSourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.S3DataSourceConfiguration =
      zio.aws.kendra.model.S3DataSourceConfiguration(
        bucketName,
        inclusionPrefixes.map(value => value),
        inclusionPatterns.map(value => value),
        exclusionPatterns.map(value => value),
        documentsMetadataConfiguration.map(value => value.asEditable),
        accessControlListConfiguration.map(value => value.asEditable)
      )
    def bucketName: S3BucketName
    def inclusionPrefixes
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def documentsMetadataConfiguration
        : Optional[zio.aws.kendra.model.DocumentsMetadataConfiguration.ReadOnly]
    def accessControlListConfiguration
        : Optional[zio.aws.kendra.model.AccessControlListConfiguration.ReadOnly]
    def getBucketName: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(bucketName)
    def getInclusionPrefixes: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPrefixes", inclusionPrefixes)
    def getInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPatterns", inclusionPatterns)
    def getExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("exclusionPatterns", exclusionPatterns)
    def getDocumentsMetadataConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DocumentsMetadataConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "documentsMetadataConfiguration",
      documentsMetadataConfiguration
    )
    def getAccessControlListConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.AccessControlListConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accessControlListConfiguration",
      accessControlListConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.S3DataSourceConfiguration
  ) extends zio.aws.kendra.model.S3DataSourceConfiguration.ReadOnly {
    override val bucketName: S3BucketName =
      zio.aws.kendra.model.primitives.S3BucketName(impl.bucketName())
    override val inclusionPrefixes
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inclusionPrefixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val documentsMetadataConfiguration: Optional[
      zio.aws.kendra.model.DocumentsMetadataConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.documentsMetadataConfiguration())
      .map(value =>
        zio.aws.kendra.model.DocumentsMetadataConfiguration.wrap(value)
      )
    override val accessControlListConfiguration: Optional[
      zio.aws.kendra.model.AccessControlListConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accessControlListConfiguration())
      .map(value =>
        zio.aws.kendra.model.AccessControlListConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.S3DataSourceConfiguration
  ): zio.aws.kendra.model.S3DataSourceConfiguration.ReadOnly = new Wrapper(impl)
}
