package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{S3ObjectKey, S3BucketName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class S3Path(bucket: S3BucketName, key: S3ObjectKey) {
  def buildAwsValue(): software.amazon.awssdk.services.kendra.model.S3Path = {
    import S3Path.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.S3Path
      .builder()
      .bucket(S3BucketName.unwrap(bucket): java.lang.String)
      .key(S3ObjectKey.unwrap(key): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.S3Path.ReadOnly =
    zio.aws.kendra.model.S3Path.wrap(buildAwsValue())
}
object S3Path {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.S3Path] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.S3Path =
      zio.aws.kendra.model.S3Path(bucket, key)
    def bucket: S3BucketName
    def key: S3ObjectKey
    def getBucket: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, S3ObjectKey] = ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.S3Path
  ) extends zio.aws.kendra.model.S3Path.ReadOnly {
    override val bucket: S3BucketName =
      zio.aws.kendra.model.primitives.S3BucketName(impl.bucket())
    override val key: S3ObjectKey =
      zio.aws.kendra.model.primitives.S3ObjectKey(impl.key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.S3Path
  ): zio.aws.kendra.model.S3Path.ReadOnly = new Wrapper(impl)
}
