package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{Url, OrganizationName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SaaSConfiguration(
    organizationName: OrganizationName,
    hostUrl: Url
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SaaSConfiguration = {
    import SaaSConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SaaSConfiguration
      .builder()
      .organizationName(
        OrganizationName.unwrap(organizationName): java.lang.String
      )
      .hostUrl(Url.unwrap(hostUrl): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SaaSConfiguration.ReadOnly =
    zio.aws.kendra.model.SaaSConfiguration.wrap(buildAwsValue())
}
object SaaSConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SaaSConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SaaSConfiguration =
      zio.aws.kendra.model.SaaSConfiguration(organizationName, hostUrl)
    def organizationName: OrganizationName
    def hostUrl: Url
    def getOrganizationName: ZIO[Any, Nothing, OrganizationName] =
      ZIO.succeed(organizationName)
    def getHostUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(hostUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SaaSConfiguration
  ) extends zio.aws.kendra.model.SaaSConfiguration.ReadOnly {
    override val organizationName: OrganizationName =
      zio.aws.kendra.model.primitives.OrganizationName(impl.organizationName())
    override val hostUrl: Url =
      zio.aws.kendra.model.primitives.Url(impl.hostUrl())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SaaSConfiguration
  ): zio.aws.kendra.model.SaaSConfiguration.ReadOnly = new Wrapper(impl)
}
