package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait SalesforceChatterFeedIncludeFilterType {
  def unwrap: software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedIncludeFilterType
}
object SalesforceChatterFeedIncludeFilterType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedIncludeFilterType
  ): zio.aws.kendra.model.SalesforceChatterFeedIncludeFilterType = value match {
    case software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedIncludeFilterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedIncludeFilterType.ACTIVE_USER =>
      val r = ACTIVE_USER
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedIncludeFilterType.STANDARD_USER =>
      val r = STANDARD_USER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.SalesforceChatterFeedIncludeFilterType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedIncludeFilterType =
      software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedIncludeFilterType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE_USER
      extends zio.aws.kendra.model.SalesforceChatterFeedIncludeFilterType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedIncludeFilterType =
      software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedIncludeFilterType.ACTIVE_USER
  }
  case object STANDARD_USER
      extends zio.aws.kendra.model.SalesforceChatterFeedIncludeFilterType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedIncludeFilterType =
      software.amazon.awssdk.services.kendra.model.SalesforceChatterFeedIncludeFilterType.STANDARD_USER
  }
}
