package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  DataSourceInclusionsExclusionsStringsMember,
  SecretArn,
  Url
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SalesforceConfiguration(
    serverUrl: Url,
    secretArn: SecretArn,
    standardObjectConfigurations: Optional[
      Iterable[zio.aws.kendra.model.SalesforceStandardObjectConfiguration]
    ] = Optional.Absent,
    knowledgeArticleConfiguration: Optional[
      zio.aws.kendra.model.SalesforceKnowledgeArticleConfiguration
    ] = Optional.Absent,
    chatterFeedConfiguration: Optional[
      zio.aws.kendra.model.SalesforceChatterFeedConfiguration
    ] = Optional.Absent,
    crawlAttachments: Optional[Boolean] = Optional.Absent,
    standardObjectAttachmentConfiguration: Optional[
      zio.aws.kendra.model.SalesforceStandardObjectAttachmentConfiguration
    ] = Optional.Absent,
    includeAttachmentFilePatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    excludeAttachmentFilePatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SalesforceConfiguration = {
    import SalesforceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SalesforceConfiguration
      .builder()
      .serverUrl(Url.unwrap(serverUrl): java.lang.String)
      .secretArn(SecretArn.unwrap(secretArn): java.lang.String)
      .optionallyWith(
        standardObjectConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.standardObjectConfigurations)
      .optionallyWith(
        knowledgeArticleConfiguration.map(value => value.buildAwsValue())
      )(_.knowledgeArticleConfiguration)
      .optionallyWith(
        chatterFeedConfiguration.map(value => value.buildAwsValue())
      )(_.chatterFeedConfiguration)
      .optionallyWith(crawlAttachments.map(value => value: java.lang.Boolean))(
        _.crawlAttachments
      )
      .optionallyWith(
        standardObjectAttachmentConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.standardObjectAttachmentConfiguration)
      .optionallyWith(
        includeAttachmentFilePatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.includeAttachmentFilePatterns)
      .optionallyWith(
        excludeAttachmentFilePatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.excludeAttachmentFilePatterns)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SalesforceConfiguration.ReadOnly =
    zio.aws.kendra.model.SalesforceConfiguration.wrap(buildAwsValue())
}
object SalesforceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SalesforceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SalesforceConfiguration =
      zio.aws.kendra.model.SalesforceConfiguration(
        serverUrl,
        secretArn,
        standardObjectConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        knowledgeArticleConfiguration.map(value => value.asEditable),
        chatterFeedConfiguration.map(value => value.asEditable),
        crawlAttachments.map(value => value),
        standardObjectAttachmentConfiguration.map(value => value.asEditable),
        includeAttachmentFilePatterns.map(value => value),
        excludeAttachmentFilePatterns.map(value => value)
      )
    def serverUrl: Url
    def secretArn: SecretArn
    def standardObjectConfigurations: Optional[
      List[zio.aws.kendra.model.SalesforceStandardObjectConfiguration.ReadOnly]
    ]
    def knowledgeArticleConfiguration: Optional[
      zio.aws.kendra.model.SalesforceKnowledgeArticleConfiguration.ReadOnly
    ]
    def chatterFeedConfiguration: Optional[
      zio.aws.kendra.model.SalesforceChatterFeedConfiguration.ReadOnly
    ]
    def crawlAttachments: Optional[Boolean]
    def standardObjectAttachmentConfiguration: Optional[
      zio.aws.kendra.model.SalesforceStandardObjectAttachmentConfiguration.ReadOnly
    ]
    def includeAttachmentFilePatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def excludeAttachmentFilePatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def getServerUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(serverUrl)
    def getSecretArn: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(secretArn)
    def getStandardObjectConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.SalesforceStandardObjectConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "standardObjectConfigurations",
      standardObjectConfigurations
    )
    def getKnowledgeArticleConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SalesforceKnowledgeArticleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "knowledgeArticleConfiguration",
      knowledgeArticleConfiguration
    )
    def getChatterFeedConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SalesforceChatterFeedConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "chatterFeedConfiguration",
      chatterFeedConfiguration
    )
    def getCrawlAttachments: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlAttachments", crawlAttachments)
    def getStandardObjectAttachmentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SalesforceStandardObjectAttachmentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "standardObjectAttachmentConfiguration",
      standardObjectAttachmentConfiguration
    )
    def getIncludeAttachmentFilePatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField(
      "includeAttachmentFilePatterns",
      includeAttachmentFilePatterns
    )
    def getExcludeAttachmentFilePatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField(
      "excludeAttachmentFilePatterns",
      excludeAttachmentFilePatterns
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SalesforceConfiguration
  ) extends zio.aws.kendra.model.SalesforceConfiguration.ReadOnly {
    override val serverUrl: Url =
      zio.aws.kendra.model.primitives.Url(impl.serverUrl())
    override val secretArn: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.secretArn())
    override val standardObjectConfigurations: Optional[
      List[zio.aws.kendra.model.SalesforceStandardObjectConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.standardObjectConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.SalesforceStandardObjectConfiguration.wrap(item)
        }.toList
      )
    override val knowledgeArticleConfiguration: Optional[
      zio.aws.kendra.model.SalesforceKnowledgeArticleConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.knowledgeArticleConfiguration())
      .map(value =>
        zio.aws.kendra.model.SalesforceKnowledgeArticleConfiguration.wrap(value)
      )
    override val chatterFeedConfiguration: Optional[
      zio.aws.kendra.model.SalesforceChatterFeedConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.chatterFeedConfiguration())
      .map(value =>
        zio.aws.kendra.model.SalesforceChatterFeedConfiguration.wrap(value)
      )
    override val crawlAttachments: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlAttachments())
      .map(value => value: Boolean)
    override val standardObjectAttachmentConfiguration: Optional[
      zio.aws.kendra.model.SalesforceStandardObjectAttachmentConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.standardObjectAttachmentConfiguration())
      .map(value =>
        zio.aws.kendra.model.SalesforceStandardObjectAttachmentConfiguration
          .wrap(value)
      )
    override val includeAttachmentFilePatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeAttachmentFilePatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val excludeAttachmentFilePatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeAttachmentFilePatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SalesforceConfiguration
  ): zio.aws.kendra.model.SalesforceConfiguration.ReadOnly = new Wrapper(impl)
}
