package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait SalesforceKnowledgeArticleState {
  def unwrap: software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleState
}
object SalesforceKnowledgeArticleState {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleState
  ): zio.aws.kendra.model.SalesforceKnowledgeArticleState = value match {
    case software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleState.DRAFT =>
      val r = DRAFT
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleState.PUBLISHED =>
      val r = PUBLISHED
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleState.ARCHIVED =>
      val r = ARCHIVED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.SalesforceKnowledgeArticleState {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleState =
      software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleState.UNKNOWN_TO_SDK_VERSION
  }
  case object DRAFT
      extends zio.aws.kendra.model.SalesforceKnowledgeArticleState {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleState =
      software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleState.DRAFT
  }
  case object PUBLISHED
      extends zio.aws.kendra.model.SalesforceKnowledgeArticleState {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleState =
      software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleState.PUBLISHED
  }
  case object ARCHIVED
      extends zio.aws.kendra.model.SalesforceKnowledgeArticleState {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleState =
      software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleState.ARCHIVED
  }
}
