package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ScoreAttributes(
    scoreConfidence: Optional[zio.aws.kendra.model.ScoreConfidence] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ScoreAttributes = {
    import ScoreAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ScoreAttributes
      .builder()
      .optionallyWith(scoreConfidence.map(value => value.unwrap))(
        _.scoreConfidence
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ScoreAttributes.ReadOnly =
    zio.aws.kendra.model.ScoreAttributes.wrap(buildAwsValue())
}
object ScoreAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ScoreAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ScoreAttributes =
      zio.aws.kendra.model.ScoreAttributes(scoreConfidence.map(value => value))
    def scoreConfidence: Optional[zio.aws.kendra.model.ScoreConfidence]
    def getScoreConfidence
        : ZIO[Any, AwsError, zio.aws.kendra.model.ScoreConfidence] =
      AwsError.unwrapOptionField("scoreConfidence", scoreConfidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ScoreAttributes
  ) extends zio.aws.kendra.model.ScoreAttributes.ReadOnly {
    override val scoreConfidence
        : Optional[zio.aws.kendra.model.ScoreConfidence] = zio.aws.core.internal
      .optionalFromNullable(impl.scoreConfidence())
      .map(value => zio.aws.kendra.model.ScoreConfidence.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ScoreAttributes
  ): zio.aws.kendra.model.ScoreAttributes.ReadOnly = new Wrapper(impl)
}
