package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  DataSourceFieldName,
  DataSourceInclusionsExclusionsStringsMember
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ServiceNowServiceCatalogConfiguration(
    crawlAttachments: Optional[Boolean] = Optional.Absent,
    includeAttachmentFilePatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    excludeAttachmentFilePatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    documentDataFieldName: DataSourceFieldName,
    documentTitleFieldName: Optional[DataSourceFieldName] = Optional.Absent,
    fieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ServiceNowServiceCatalogConfiguration = {
    import ServiceNowServiceCatalogConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ServiceNowServiceCatalogConfiguration
      .builder()
      .optionallyWith(crawlAttachments.map(value => value: java.lang.Boolean))(
        _.crawlAttachments
      )
      .optionallyWith(
        includeAttachmentFilePatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.includeAttachmentFilePatterns)
      .optionallyWith(
        excludeAttachmentFilePatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.excludeAttachmentFilePatterns)
      .documentDataFieldName(
        DataSourceFieldName.unwrap(documentDataFieldName): java.lang.String
      )
      .optionallyWith(
        documentTitleFieldName.map(value =>
          DataSourceFieldName.unwrap(value): java.lang.String
        )
      )(_.documentTitleFieldName)
      .optionallyWith(
        fieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fieldMappings)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.ServiceNowServiceCatalogConfiguration.ReadOnly =
    zio.aws.kendra.model.ServiceNowServiceCatalogConfiguration
      .wrap(buildAwsValue())
}
object ServiceNowServiceCatalogConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ServiceNowServiceCatalogConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ServiceNowServiceCatalogConfiguration =
      zio.aws.kendra.model.ServiceNowServiceCatalogConfiguration(
        crawlAttachments.map(value => value),
        includeAttachmentFilePatterns.map(value => value),
        excludeAttachmentFilePatterns.map(value => value),
        documentDataFieldName,
        documentTitleFieldName.map(value => value),
        fieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def crawlAttachments: Optional[Boolean]
    def includeAttachmentFilePatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def excludeAttachmentFilePatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def documentDataFieldName: DataSourceFieldName
    def documentTitleFieldName: Optional[DataSourceFieldName]
    def fieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def getCrawlAttachments: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlAttachments", crawlAttachments)
    def getIncludeAttachmentFilePatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField(
      "includeAttachmentFilePatterns",
      includeAttachmentFilePatterns
    )
    def getExcludeAttachmentFilePatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField(
      "excludeAttachmentFilePatterns",
      excludeAttachmentFilePatterns
    )
    def getDocumentDataFieldName: ZIO[Any, Nothing, DataSourceFieldName] =
      ZIO.succeed(documentDataFieldName)
    def getDocumentTitleFieldName: ZIO[Any, AwsError, DataSourceFieldName] =
      AwsError.unwrapOptionField(
        "documentTitleFieldName",
        documentTitleFieldName
      )
    def getFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("fieldMappings", fieldMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ServiceNowServiceCatalogConfiguration
  ) extends zio.aws.kendra.model.ServiceNowServiceCatalogConfiguration.ReadOnly {
    override val crawlAttachments: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlAttachments())
      .map(value => value: Boolean)
    override val includeAttachmentFilePatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeAttachmentFilePatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val excludeAttachmentFilePatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeAttachmentFilePatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val documentDataFieldName: DataSourceFieldName =
      zio.aws.kendra.model.primitives
        .DataSourceFieldName(impl.documentDataFieldName())
    override val documentTitleFieldName: Optional[DataSourceFieldName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentTitleFieldName())
        .map(value =>
          zio.aws.kendra.model.primitives.DataSourceFieldName(value)
        )
    override val fieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ServiceNowServiceCatalogConfiguration
  ): zio.aws.kendra.model.ServiceNowServiceCatalogConfiguration.ReadOnly =
    new Wrapper(impl)
}
