package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  DataSourceFieldName,
  DataSourceInclusionsExclusionsStringsMember,
  SecretArn,
  Url
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SharePointConfiguration(
    sharePointVersion: zio.aws.kendra.model.SharePointVersion,
    urls: Iterable[Url],
    secretArn: SecretArn,
    crawlAttachments: Optional[Boolean] = Optional.Absent,
    useChangeLog: Optional[Boolean] = Optional.Absent,
    inclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    exclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    vpcConfiguration: Optional[
      zio.aws.kendra.model.DataSourceVpcConfiguration
    ] = Optional.Absent,
    fieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    documentTitleFieldName: Optional[DataSourceFieldName] = Optional.Absent,
    disableLocalGroups: Optional[Boolean] = Optional.Absent,
    sslCertificateS3Path: Optional[zio.aws.kendra.model.S3Path] =
      Optional.Absent,
    authenticationType: Optional[
      zio.aws.kendra.model.SharePointOnlineAuthenticationType
    ] = Optional.Absent,
    proxyConfiguration: Optional[zio.aws.kendra.model.ProxyConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SharePointConfiguration = {
    import SharePointConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SharePointConfiguration
      .builder()
      .sharePointVersion(sharePointVersion.unwrap)
      .urls(urls.map { item =>
        Url.unwrap(item): java.lang.String
      }.asJavaCollection)
      .secretArn(SecretArn.unwrap(secretArn): java.lang.String)
      .optionallyWith(crawlAttachments.map(value => value: java.lang.Boolean))(
        _.crawlAttachments
      )
      .optionallyWith(useChangeLog.map(value => value: java.lang.Boolean))(
        _.useChangeLog
      )
      .optionallyWith(
        inclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPatterns)
      .optionallyWith(
        exclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionPatterns)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(
        fieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fieldMappings)
      .optionallyWith(
        documentTitleFieldName.map(value =>
          DataSourceFieldName.unwrap(value): java.lang.String
        )
      )(_.documentTitleFieldName)
      .optionallyWith(
        disableLocalGroups.map(value => value: java.lang.Boolean)
      )(_.disableLocalGroups)
      .optionallyWith(sslCertificateS3Path.map(value => value.buildAwsValue()))(
        _.sslCertificateS3Path
      )
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .optionallyWith(proxyConfiguration.map(value => value.buildAwsValue()))(
        _.proxyConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SharePointConfiguration.ReadOnly =
    zio.aws.kendra.model.SharePointConfiguration.wrap(buildAwsValue())
}
object SharePointConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SharePointConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SharePointConfiguration =
      zio.aws.kendra.model.SharePointConfiguration(
        sharePointVersion,
        urls,
        secretArn,
        crawlAttachments.map(value => value),
        useChangeLog.map(value => value),
        inclusionPatterns.map(value => value),
        exclusionPatterns.map(value => value),
        vpcConfiguration.map(value => value.asEditable),
        fieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        documentTitleFieldName.map(value => value),
        disableLocalGroups.map(value => value),
        sslCertificateS3Path.map(value => value.asEditable),
        authenticationType.map(value => value),
        proxyConfiguration.map(value => value.asEditable)
      )
    def sharePointVersion: zio.aws.kendra.model.SharePointVersion
    def urls: List[Url]
    def secretArn: SecretArn
    def crawlAttachments: Optional[Boolean]
    def useChangeLog: Optional[Boolean]
    def inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly]
    def fieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def documentTitleFieldName: Optional[DataSourceFieldName]
    def disableLocalGroups: Optional[Boolean]
    def sslCertificateS3Path: Optional[zio.aws.kendra.model.S3Path.ReadOnly]
    def authenticationType
        : Optional[zio.aws.kendra.model.SharePointOnlineAuthenticationType]
    def proxyConfiguration
        : Optional[zio.aws.kendra.model.ProxyConfiguration.ReadOnly]
    def getSharePointVersion
        : ZIO[Any, Nothing, zio.aws.kendra.model.SharePointVersion] =
      ZIO.succeed(sharePointVersion)
    def getUrls: ZIO[Any, Nothing, List[Url]] = ZIO.succeed(urls)
    def getSecretArn: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(secretArn)
    def getCrawlAttachments: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlAttachments", crawlAttachments)
    def getUseChangeLog: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useChangeLog", useChangeLog)
    def getInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPatterns", inclusionPatterns)
    def getExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("exclusionPatterns", exclusionPatterns)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("fieldMappings", fieldMappings)
    def getDocumentTitleFieldName: ZIO[Any, AwsError, DataSourceFieldName] =
      AwsError.unwrapOptionField(
        "documentTitleFieldName",
        documentTitleFieldName
      )
    def getDisableLocalGroups: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disableLocalGroups", disableLocalGroups)
    def getSslCertificateS3Path
        : ZIO[Any, AwsError, zio.aws.kendra.model.S3Path.ReadOnly] =
      AwsError.unwrapOptionField("sslCertificateS3Path", sslCertificateS3Path)
    def getAuthenticationType: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SharePointOnlineAuthenticationType
    ] = AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getProxyConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.ProxyConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("proxyConfiguration", proxyConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SharePointConfiguration
  ) extends zio.aws.kendra.model.SharePointConfiguration.ReadOnly {
    override val sharePointVersion: zio.aws.kendra.model.SharePointVersion =
      zio.aws.kendra.model.SharePointVersion.wrap(impl.sharePointVersion())
    override val urls: List[Url] = impl
      .urls()
      .asScala
      .map { item =>
        zio.aws.kendra.model.primitives.Url(item)
      }
      .toList
    override val secretArn: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.secretArn())
    override val crawlAttachments: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlAttachments())
      .map(value => value: Boolean)
    override val useChangeLog: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.useChangeLog())
      .map(value => value: Boolean)
    override val inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value =>
          zio.aws.kendra.model.DataSourceVpcConfiguration.wrap(value)
        )
    override val fieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val documentTitleFieldName: Optional[DataSourceFieldName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentTitleFieldName())
        .map(value =>
          zio.aws.kendra.model.primitives.DataSourceFieldName(value)
        )
    override val disableLocalGroups: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disableLocalGroups())
      .map(value => value: Boolean)
    override val sslCertificateS3Path
        : Optional[zio.aws.kendra.model.S3Path.ReadOnly] = zio.aws.core.internal
      .optionalFromNullable(impl.sslCertificateS3Path())
      .map(value => zio.aws.kendra.model.S3Path.wrap(value))
    override val authenticationType
        : Optional[zio.aws.kendra.model.SharePointOnlineAuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationType())
        .map(value =>
          zio.aws.kendra.model.SharePointOnlineAuthenticationType.wrap(value)
        )
    override val proxyConfiguration
        : Optional[zio.aws.kendra.model.ProxyConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxyConfiguration())
        .map(value => zio.aws.kendra.model.ProxyConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SharePointConfiguration
  ): zio.aws.kendra.model.SharePointConfiguration.ReadOnly = new Wrapper(impl)
}
