package zio.aws.kendra.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  SecretArn,
  LookBackPeriod,
  TeamId,
  DataSourceInclusionsExclusionsStringsMember,
  SinceCrawlDate
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SlackConfiguration(
    teamId: TeamId,
    secretArn: SecretArn,
    vpcConfiguration: Optional[
      zio.aws.kendra.model.DataSourceVpcConfiguration
    ] = Optional.Absent,
    slackEntityList: Iterable[zio.aws.kendra.model.SlackEntity],
    useChangeLog: Optional[Boolean] = Optional.Absent,
    crawlBotMessage: Optional[Boolean] = Optional.Absent,
    excludeArchived: Optional[Boolean] = Optional.Absent,
    sinceCrawlDate: SinceCrawlDate,
    lookBackPeriod: Optional[LookBackPeriod] = Optional.Absent,
    privateChannelFilter: Optional[Iterable[String]] = Optional.Absent,
    publicChannelFilter: Optional[Iterable[String]] = Optional.Absent,
    inclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    exclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    fieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SlackConfiguration = {
    import SlackConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SlackConfiguration
      .builder()
      .teamId(TeamId.unwrap(teamId): java.lang.String)
      .secretArn(SecretArn.unwrap(secretArn): java.lang.String)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .slackEntityListWithStrings(slackEntityList.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(useChangeLog.map(value => value: java.lang.Boolean))(
        _.useChangeLog
      )
      .optionallyWith(crawlBotMessage.map(value => value: java.lang.Boolean))(
        _.crawlBotMessage
      )
      .optionallyWith(excludeArchived.map(value => value: java.lang.Boolean))(
        _.excludeArchived
      )
      .sinceCrawlDate(SinceCrawlDate.unwrap(sinceCrawlDate): java.lang.String)
      .optionallyWith(
        lookBackPeriod.map(value => LookBackPeriod.unwrap(value): Integer)
      )(_.lookBackPeriod)
      .optionallyWith(
        privateChannelFilter.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.privateChannelFilter)
      .optionallyWith(
        publicChannelFilter.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.publicChannelFilter)
      .optionallyWith(
        inclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPatterns)
      .optionallyWith(
        exclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionPatterns)
      .optionallyWith(
        fieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fieldMappings)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SlackConfiguration.ReadOnly =
    zio.aws.kendra.model.SlackConfiguration.wrap(buildAwsValue())
}
object SlackConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SlackConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SlackConfiguration =
      zio.aws.kendra.model.SlackConfiguration(
        teamId,
        secretArn,
        vpcConfiguration.map(value => value.asEditable),
        slackEntityList,
        useChangeLog.map(value => value),
        crawlBotMessage.map(value => value),
        excludeArchived.map(value => value),
        sinceCrawlDate,
        lookBackPeriod.map(value => value),
        privateChannelFilter.map(value => value),
        publicChannelFilter.map(value => value),
        inclusionPatterns.map(value => value),
        exclusionPatterns.map(value => value),
        fieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def teamId: TeamId
    def secretArn: SecretArn
    def vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly]
    def slackEntityList: List[zio.aws.kendra.model.SlackEntity]
    def useChangeLog: Optional[Boolean]
    def crawlBotMessage: Optional[Boolean]
    def excludeArchived: Optional[Boolean]
    def sinceCrawlDate: SinceCrawlDate
    def lookBackPeriod: Optional[LookBackPeriod]
    def privateChannelFilter: Optional[List[String]]
    def publicChannelFilter: Optional[List[String]]
    def inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def fieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def getTeamId: ZIO[Any, Nothing, TeamId] = ZIO.succeed(teamId)
    def getSecretArn: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(secretArn)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getSlackEntityList
        : ZIO[Any, Nothing, List[zio.aws.kendra.model.SlackEntity]] =
      ZIO.succeed(slackEntityList)
    def getUseChangeLog: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useChangeLog", useChangeLog)
    def getCrawlBotMessage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlBotMessage", crawlBotMessage)
    def getExcludeArchived: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("excludeArchived", excludeArchived)
    def getSinceCrawlDate: ZIO[Any, Nothing, SinceCrawlDate] =
      ZIO.succeed(sinceCrawlDate)
    def getLookBackPeriod: ZIO[Any, AwsError, LookBackPeriod] =
      AwsError.unwrapOptionField("lookBackPeriod", lookBackPeriod)
    def getPrivateChannelFilter: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("privateChannelFilter", privateChannelFilter)
    def getPublicChannelFilter: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("publicChannelFilter", publicChannelFilter)
    def getInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPatterns", inclusionPatterns)
    def getExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("exclusionPatterns", exclusionPatterns)
    def getFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("fieldMappings", fieldMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SlackConfiguration
  ) extends zio.aws.kendra.model.SlackConfiguration.ReadOnly {
    override val teamId: TeamId =
      zio.aws.kendra.model.primitives.TeamId(impl.teamId())
    override val secretArn: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.secretArn())
    override val vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value =>
          zio.aws.kendra.model.DataSourceVpcConfiguration.wrap(value)
        )
    override val slackEntityList: List[zio.aws.kendra.model.SlackEntity] = impl
      .slackEntityList()
      .asScala
      .map { item =>
        zio.aws.kendra.model.SlackEntity.wrap(item)
      }
      .toList
    override val useChangeLog: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.useChangeLog())
      .map(value => value: Boolean)
    override val crawlBotMessage: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlBotMessage())
      .map(value => value: Boolean)
    override val excludeArchived: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.excludeArchived())
      .map(value => value: Boolean)
    override val sinceCrawlDate: SinceCrawlDate =
      zio.aws.kendra.model.primitives.SinceCrawlDate(impl.sinceCrawlDate())
    override val lookBackPeriod: Optional[LookBackPeriod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lookBackPeriod())
        .map(value => zio.aws.kendra.model.primitives.LookBackPeriod(value))
    override val privateChannelFilter: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateChannelFilter())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val publicChannelFilter: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicChannelFilter())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val fieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SlackConfiguration
  ): zio.aws.kendra.model.SlackConfiguration.ReadOnly = new Wrapper(impl)
}
