package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait SlackEntity {
  def unwrap: software.amazon.awssdk.services.kendra.model.SlackEntity
}
object SlackEntity {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.SlackEntity
  ): zio.aws.kendra.model.SlackEntity = value match {
    case software.amazon.awssdk.services.kendra.model.SlackEntity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.SlackEntity.PUBLIC_CHANNEL =>
      val r = PUBLIC_CHANNEL
      r
    case software.amazon.awssdk.services.kendra.model.SlackEntity.PRIVATE_CHANNEL =>
      val r = PRIVATE_CHANNEL
      r
    case software.amazon.awssdk.services.kendra.model.SlackEntity.GROUP_MESSAGE =>
      val r = GROUP_MESSAGE
      r
    case software.amazon.awssdk.services.kendra.model.SlackEntity.DIRECT_MESSAGE =>
      val r = DIRECT_MESSAGE
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.SlackEntity {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SlackEntity =
      software.amazon.awssdk.services.kendra.model.SlackEntity.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLIC_CHANNEL extends zio.aws.kendra.model.SlackEntity {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SlackEntity =
      software.amazon.awssdk.services.kendra.model.SlackEntity.PUBLIC_CHANNEL
  }
  case object PRIVATE_CHANNEL extends zio.aws.kendra.model.SlackEntity {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SlackEntity =
      software.amazon.awssdk.services.kendra.model.SlackEntity.PRIVATE_CHANNEL
  }
  case object GROUP_MESSAGE extends zio.aws.kendra.model.SlackEntity {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SlackEntity =
      software.amazon.awssdk.services.kendra.model.SlackEntity.GROUP_MESSAGE
  }
  case object DIRECT_MESSAGE extends zio.aws.kendra.model.SlackEntity {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SlackEntity =
      software.amazon.awssdk.services.kendra.model.SlackEntity.DIRECT_MESSAGE
  }
}
