package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DocumentAttributeKey
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SourceDocument(
    documentId: Optional[String] = Optional.Absent,
    suggestionAttributes: Optional[Iterable[DocumentAttributeKey]] =
      Optional.Absent,
    additionalAttributes: Optional[
      Iterable[zio.aws.kendra.model.DocumentAttribute]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SourceDocument = {
    import SourceDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SourceDocument
      .builder()
      .optionallyWith(documentId.map(value => value: java.lang.String))(
        _.documentId
      )
      .optionallyWith(
        suggestionAttributes.map(value =>
          value.map { item =>
            DocumentAttributeKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.suggestionAttributes)
      .optionallyWith(
        additionalAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalAttributes)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SourceDocument.ReadOnly =
    zio.aws.kendra.model.SourceDocument.wrap(buildAwsValue())
}
object SourceDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SourceDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SourceDocument =
      zio.aws.kendra.model.SourceDocument(
        documentId.map(value => value),
        suggestionAttributes.map(value => value),
        additionalAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def documentId: Optional[String]
    def suggestionAttributes: Optional[List[DocumentAttributeKey]]
    def additionalAttributes
        : Optional[List[zio.aws.kendra.model.DocumentAttribute.ReadOnly]]
    def getDocumentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("documentId", documentId)
    def getSuggestionAttributes
        : ZIO[Any, AwsError, List[DocumentAttributeKey]] =
      AwsError.unwrapOptionField("suggestionAttributes", suggestionAttributes)
    def getAdditionalAttributes: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DocumentAttribute.ReadOnly
    ]] =
      AwsError.unwrapOptionField("additionalAttributes", additionalAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SourceDocument
  ) extends zio.aws.kendra.model.SourceDocument.ReadOnly {
    override val documentId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.documentId())
      .map(value => value: String)
    override val suggestionAttributes: Optional[List[DocumentAttributeKey]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suggestionAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives.DocumentAttributeKey(item)
          }.toList
        )
    override val additionalAttributes
        : Optional[List[zio.aws.kendra.model.DocumentAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.DocumentAttribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SourceDocument
  ): zio.aws.kendra.model.SourceDocument.ReadOnly = new Wrapper(impl)
}
