package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SpellCorrectionConfiguration(
    includeQuerySpellCheckSuggestions: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SpellCorrectionConfiguration = {
    import SpellCorrectionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SpellCorrectionConfiguration
      .builder()
      .includeQuerySpellCheckSuggestions(
        includeQuerySpellCheckSuggestions: java.lang.Boolean
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SpellCorrectionConfiguration.ReadOnly =
    zio.aws.kendra.model.SpellCorrectionConfiguration.wrap(buildAwsValue())
}
object SpellCorrectionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SpellCorrectionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SpellCorrectionConfiguration =
      zio.aws.kendra.model
        .SpellCorrectionConfiguration(includeQuerySpellCheckSuggestions)
    def includeQuerySpellCheckSuggestions: Boolean
    def getIncludeQuerySpellCheckSuggestions: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(includeQuerySpellCheckSuggestions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SpellCorrectionConfiguration
  ) extends zio.aws.kendra.model.SpellCorrectionConfiguration.ReadOnly {
    override val includeQuerySpellCheckSuggestions: Boolean =
      impl.includeQuerySpellCheckSuggestions(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SpellCorrectionConfiguration
  ): zio.aws.kendra.model.SpellCorrectionConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
