package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartDataSourceSyncJobResponse(
    executionId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobResponse = {
    import StartDataSourceSyncJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobResponse
      .builder()
      .optionallyWith(executionId.map(value => value: java.lang.String))(
        _.executionId
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.StartDataSourceSyncJobResponse.ReadOnly =
    zio.aws.kendra.model.StartDataSourceSyncJobResponse.wrap(buildAwsValue())
}
object StartDataSourceSyncJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.StartDataSourceSyncJobResponse =
      zio.aws.kendra.model
        .StartDataSourceSyncJobResponse(executionId.map(value => value))
    def executionId: Optional[String]
    def getExecutionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executionId", executionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobResponse
  ) extends zio.aws.kendra.model.StartDataSourceSyncJobResponse.ReadOnly {
    override val executionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.executionId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobResponse
  ): zio.aws.kendra.model.StartDataSourceSyncJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
