package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DocumentId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Status(
    documentId: Optional[DocumentId] = Optional.Absent,
    documentStatus: Optional[zio.aws.kendra.model.DocumentStatus] =
      Optional.Absent,
    failureCode: Optional[String] = Optional.Absent,
    failureReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.kendra.model.Status = {
    import Status.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Status
      .builder()
      .optionallyWith(
        documentId.map(value => DocumentId.unwrap(value): java.lang.String)
      )(_.documentId)
      .optionallyWith(documentStatus.map(value => value.unwrap))(
        _.documentStatus
      )
      .optionallyWith(failureCode.map(value => value: java.lang.String))(
        _.failureCode
      )
      .optionallyWith(failureReason.map(value => value: java.lang.String))(
        _.failureReason
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Status.ReadOnly =
    zio.aws.kendra.model.Status.wrap(buildAwsValue())
}
object Status {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Status] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Status = zio.aws.kendra.model.Status(
      documentId.map(value => value),
      documentStatus.map(value => value),
      failureCode.map(value => value),
      failureReason.map(value => value)
    )
    def documentId: Optional[DocumentId]
    def documentStatus: Optional[zio.aws.kendra.model.DocumentStatus]
    def failureCode: Optional[String]
    def failureReason: Optional[String]
    def getDocumentId: ZIO[Any, AwsError, DocumentId] =
      AwsError.unwrapOptionField("documentId", documentId)
    def getDocumentStatus
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentStatus] =
      AwsError.unwrapOptionField("documentStatus", documentStatus)
    def getFailureCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Status
  ) extends zio.aws.kendra.model.Status.ReadOnly {
    override val documentId: Optional[DocumentId] = zio.aws.core.internal
      .optionalFromNullable(impl.documentId())
      .map(value => zio.aws.kendra.model.primitives.DocumentId(value))
    override val documentStatus: Optional[zio.aws.kendra.model.DocumentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentStatus())
        .map(value => zio.aws.kendra.model.DocumentStatus.wrap(value))
    override val failureCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureCode())
      .map(value => value: String)
    override val failureReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Status
  ): zio.aws.kendra.model.Status.ReadOnly = new Wrapper(impl)
}
