package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{ObjectBoolean, DocumentAttributeKey}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SuggestableConfig(
    attributeName: Optional[DocumentAttributeKey] = Optional.Absent,
    suggestable: Optional[ObjectBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SuggestableConfig = {
    import SuggestableConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SuggestableConfig
      .builder()
      .optionallyWith(
        attributeName.map(value =>
          DocumentAttributeKey.unwrap(value): java.lang.String
        )
      )(_.attributeName)
      .optionallyWith(
        suggestable.map(value => ObjectBoolean.unwrap(value): java.lang.Boolean)
      )(_.suggestable)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SuggestableConfig.ReadOnly =
    zio.aws.kendra.model.SuggestableConfig.wrap(buildAwsValue())
}
object SuggestableConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SuggestableConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SuggestableConfig =
      zio.aws.kendra.model.SuggestableConfig(
        attributeName.map(value => value),
        suggestable.map(value => value)
      )
    def attributeName: Optional[DocumentAttributeKey]
    def suggestable: Optional[ObjectBoolean]
    def getAttributeName: ZIO[Any, AwsError, DocumentAttributeKey] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getSuggestable: ZIO[Any, AwsError, ObjectBoolean] =
      AwsError.unwrapOptionField("suggestable", suggestable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SuggestableConfig
  ) extends zio.aws.kendra.model.SuggestableConfig.ReadOnly {
    override val attributeName: Optional[DocumentAttributeKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeName())
        .map(value =>
          zio.aws.kendra.model.primitives.DocumentAttributeKey(value)
        )
    override val suggestable: Optional[ObjectBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.suggestable())
      .map(value => zio.aws.kendra.model.primitives.ObjectBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SuggestableConfig
  ): zio.aws.kendra.model.SuggestableConfig.ReadOnly = new Wrapper(impl)
}
