package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SuggestionTextWithHighlights(
    text: Optional[String] = Optional.Absent,
    highlights: Optional[Iterable[zio.aws.kendra.model.SuggestionHighlight]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SuggestionTextWithHighlights = {
    import SuggestionTextWithHighlights.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SuggestionTextWithHighlights
      .builder()
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .optionallyWith(
        highlights.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.highlights)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SuggestionTextWithHighlights.ReadOnly =
    zio.aws.kendra.model.SuggestionTextWithHighlights.wrap(buildAwsValue())
}
object SuggestionTextWithHighlights {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SuggestionTextWithHighlights
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SuggestionTextWithHighlights =
      zio.aws.kendra.model.SuggestionTextWithHighlights(
        text.map(value => value),
        highlights.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def text: Optional[String]
    def highlights
        : Optional[List[zio.aws.kendra.model.SuggestionHighlight.ReadOnly]]
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getHighlights: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.SuggestionHighlight.ReadOnly
    ]] = AwsError.unwrapOptionField("highlights", highlights)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SuggestionTextWithHighlights
  ) extends zio.aws.kendra.model.SuggestionTextWithHighlights.ReadOnly {
    override val text: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value => value: String)
    override val highlights
        : Optional[List[zio.aws.kendra.model.SuggestionHighlight.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.highlights())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.SuggestionHighlight.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SuggestionTextWithHighlights
  ): zio.aws.kendra.model.SuggestionTextWithHighlights.ReadOnly = new Wrapper(
    impl
  )
}
