package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait SuggestionType {
  def unwrap: software.amazon.awssdk.services.kendra.model.SuggestionType
}
object SuggestionType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.SuggestionType
  ): zio.aws.kendra.model.SuggestionType = value match {
    case software.amazon.awssdk.services.kendra.model.SuggestionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.SuggestionType.QUERY =>
      val r = QUERY
      r
    case software.amazon.awssdk.services.kendra.model.SuggestionType.DOCUMENT_ATTRIBUTES =>
      val r = DOCUMENT_ATTRIBUTES
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.SuggestionType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SuggestionType =
      software.amazon.awssdk.services.kendra.model.SuggestionType.UNKNOWN_TO_SDK_VERSION
  }
  case object QUERY extends zio.aws.kendra.model.SuggestionType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SuggestionType =
      software.amazon.awssdk.services.kendra.model.SuggestionType.QUERY
  }
  case object DOCUMENT_ATTRIBUTES extends zio.aws.kendra.model.SuggestionType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SuggestionType =
      software.amazon.awssdk.services.kendra.model.SuggestionType.DOCUMENT_ATTRIBUTES
  }
}
