package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SuggestionValue(
    text: Optional[zio.aws.kendra.model.SuggestionTextWithHighlights] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SuggestionValue = {
    import SuggestionValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SuggestionValue
      .builder()
      .optionallyWith(text.map(value => value.buildAwsValue()))(_.text)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SuggestionValue.ReadOnly =
    zio.aws.kendra.model.SuggestionValue.wrap(buildAwsValue())
}
object SuggestionValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SuggestionValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SuggestionValue =
      zio.aws.kendra.model.SuggestionValue(text.map(value => value.asEditable))
    def text
        : Optional[zio.aws.kendra.model.SuggestionTextWithHighlights.ReadOnly]
    def getText: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SuggestionTextWithHighlights.ReadOnly
    ] = AwsError.unwrapOptionField("text", text)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SuggestionValue
  ) extends zio.aws.kendra.model.SuggestionValue.ReadOnly {
    override val text
        : Optional[zio.aws.kendra.model.SuggestionTextWithHighlights.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.text())
        .map(value =>
          zio.aws.kendra.model.SuggestionTextWithHighlights.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SuggestionValue
  ): zio.aws.kendra.model.SuggestionValue.ReadOnly = new Wrapper(impl)
}
