package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TableCell(
    value: Optional[String] = Optional.Absent,
    topAnswer: Optional[Boolean] = Optional.Absent,
    highlighted: Optional[Boolean] = Optional.Absent,
    header: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.TableCell = {
    import TableCell.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.TableCell
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(topAnswer.map(value => value: java.lang.Boolean))(
        _.topAnswer
      )
      .optionallyWith(highlighted.map(value => value: java.lang.Boolean))(
        _.highlighted
      )
      .optionallyWith(header.map(value => value: java.lang.Boolean))(_.header)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.TableCell.ReadOnly =
    zio.aws.kendra.model.TableCell.wrap(buildAwsValue())
}
object TableCell {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.TableCell] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.TableCell =
      zio.aws.kendra.model.TableCell(
        value.map(value => value),
        topAnswer.map(value => value),
        highlighted.map(value => value),
        header.map(value => value)
      )
    def value: Optional[String]
    def topAnswer: Optional[Boolean]
    def highlighted: Optional[Boolean]
    def header: Optional[Boolean]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getTopAnswer: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("topAnswer", topAnswer)
    def getHighlighted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("highlighted", highlighted)
    def getHeader: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("header", header)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.TableCell
  ) extends zio.aws.kendra.model.TableCell.ReadOnly {
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val topAnswer: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.topAnswer())
      .map(value => value: Boolean)
    override val highlighted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.highlighted())
      .map(value => value: Boolean)
    override val header: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.header())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.TableCell
  ): zio.aws.kendra.model.TableCell.ReadOnly = new Wrapper(impl)
}
