package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{TagValue, TagKey}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Tag(key: TagKey, value: TagValue) {
  def buildAwsValue(): software.amazon.awssdk.services.kendra.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .value(TagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Tag.ReadOnly =
    zio.aws.kendra.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Tag =
      zio.aws.kendra.model.Tag(key, value)
    def key: TagKey
    def value: TagValue
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Tag
  ) extends zio.aws.kendra.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.kendra.model.primitives.TagKey(impl.key())
    override val value: TagValue =
      zio.aws.kendra.model.primitives.TagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Tag
  ): zio.aws.kendra.model.Tag.ReadOnly = new Wrapper(impl)
}
