package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TemplateConfiguration(
    template: Optional[zio.aws.kendra.model.Template] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.TemplateConfiguration = {
    import TemplateConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.TemplateConfiguration
      .builder()
      .optionallyWith(template.map(value => value))(_.template)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.TemplateConfiguration.ReadOnly =
    zio.aws.kendra.model.TemplateConfiguration.wrap(buildAwsValue())
}
object TemplateConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.TemplateConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.TemplateConfiguration =
      zio.aws.kendra.model.TemplateConfiguration(template.map(value => value))
    def template: Optional[software.amazon.awssdk.core.document.Document]
    def getTemplate
        : ZIO[Any, AwsError, software.amazon.awssdk.core.document.Document] =
      AwsError.unwrapOptionField("template", template)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.TemplateConfiguration
  ) extends zio.aws.kendra.model.TemplateConfiguration.ReadOnly {
    override val template
        : Optional[software.amazon.awssdk.core.document.Document] =
      zio.aws.core.internal.optionalFromNullable(impl.template())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.TemplateConfiguration
  ): zio.aws.kendra.model.TemplateConfiguration.ReadOnly = new Wrapper(impl)
}
