package zio.aws.kendra.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  IndexedTextBytes,
  IndexedTextDocumentsCount
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TextDocumentStatistics(
    indexedTextDocumentsCount: IndexedTextDocumentsCount,
    indexedTextBytes: IndexedTextBytes
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.TextDocumentStatistics = {
    import TextDocumentStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.TextDocumentStatistics
      .builder()
      .indexedTextDocumentsCount(
        IndexedTextDocumentsCount.unwrap(indexedTextDocumentsCount): Integer
      )
      .indexedTextBytes(
        IndexedTextBytes.unwrap(indexedTextBytes): java.lang.Long
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.TextDocumentStatistics.ReadOnly =
    zio.aws.kendra.model.TextDocumentStatistics.wrap(buildAwsValue())
}
object TextDocumentStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.TextDocumentStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.TextDocumentStatistics =
      zio.aws.kendra.model
        .TextDocumentStatistics(indexedTextDocumentsCount, indexedTextBytes)
    def indexedTextDocumentsCount: IndexedTextDocumentsCount
    def indexedTextBytes: IndexedTextBytes
    def getIndexedTextDocumentsCount
        : ZIO[Any, Nothing, IndexedTextDocumentsCount] =
      ZIO.succeed(indexedTextDocumentsCount)
    def getIndexedTextBytes: ZIO[Any, Nothing, IndexedTextBytes] =
      ZIO.succeed(indexedTextBytes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.TextDocumentStatistics
  ) extends zio.aws.kendra.model.TextDocumentStatistics.ReadOnly {
    override val indexedTextDocumentsCount: IndexedTextDocumentsCount =
      zio.aws.kendra.model.primitives
        .IndexedTextDocumentsCount(impl.indexedTextDocumentsCount())
    override val indexedTextBytes: IndexedTextBytes =
      zio.aws.kendra.model.primitives.IndexedTextBytes(impl.indexedTextBytes())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.TextDocumentStatistics
  ): zio.aws.kendra.model.TextDocumentStatistics.ReadOnly = new Wrapper(impl)
}
