package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TextWithHighlights(
    text: Optional[String] = Optional.Absent,
    highlights: Optional[Iterable[zio.aws.kendra.model.Highlight]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.TextWithHighlights = {
    import TextWithHighlights.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.TextWithHighlights
      .builder()
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .optionallyWith(
        highlights.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.highlights)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.TextWithHighlights.ReadOnly =
    zio.aws.kendra.model.TextWithHighlights.wrap(buildAwsValue())
}
object TextWithHighlights {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.TextWithHighlights
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.TextWithHighlights =
      zio.aws.kendra.model.TextWithHighlights(
        text.map(value => value),
        highlights.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def text: Optional[String]
    def highlights: Optional[List[zio.aws.kendra.model.Highlight.ReadOnly]]
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getHighlights
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.Highlight.ReadOnly]] =
      AwsError.unwrapOptionField("highlights", highlights)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.TextWithHighlights
  ) extends zio.aws.kendra.model.TextWithHighlights.ReadOnly {
    override val text: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value => value: String)
    override val highlights
        : Optional[List[zio.aws.kendra.model.Highlight.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.highlights())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.Highlight.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.TextWithHighlights
  ): zio.aws.kendra.model.TextWithHighlights.ReadOnly = new Wrapper(impl)
}
