package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  Description,
  AccessControlConfigurationName,
  AccessControlConfigurationId,
  IndexId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateAccessControlConfigurationRequest(
    indexId: IndexId,
    id: AccessControlConfigurationId,
    name: Optional[AccessControlConfigurationName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    accessControlList: Optional[Iterable[zio.aws.kendra.model.Principal]] =
      Optional.Absent,
    hierarchicalAccessControlList: Optional[
      Iterable[zio.aws.kendra.model.HierarchicalPrincipal]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UpdateAccessControlConfigurationRequest = {
    import UpdateAccessControlConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UpdateAccessControlConfigurationRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .id(AccessControlConfigurationId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value =>
          AccessControlConfigurationName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        accessControlList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessControlList)
      .optionallyWith(
        hierarchicalAccessControlList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hierarchicalAccessControlList)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.UpdateAccessControlConfigurationRequest.ReadOnly =
    zio.aws.kendra.model.UpdateAccessControlConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateAccessControlConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UpdateAccessControlConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.UpdateAccessControlConfigurationRequest =
      zio.aws.kendra.model.UpdateAccessControlConfigurationRequest(
        indexId,
        id,
        name.map(value => value),
        description.map(value => value),
        accessControlList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hierarchicalAccessControlList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def indexId: IndexId
    def id: AccessControlConfigurationId
    def name: Optional[AccessControlConfigurationName]
    def description: Optional[Description]
    def accessControlList
        : Optional[List[zio.aws.kendra.model.Principal.ReadOnly]]
    def hierarchicalAccessControlList
        : Optional[List[zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly]]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getId: ZIO[Any, Nothing, AccessControlConfigurationId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, AccessControlConfigurationName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getAccessControlList
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.Principal.ReadOnly]] =
      AwsError.unwrapOptionField("accessControlList", accessControlList)
    def getHierarchicalAccessControlList: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "hierarchicalAccessControlList",
      hierarchicalAccessControlList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UpdateAccessControlConfigurationRequest
  ) extends zio.aws.kendra.model.UpdateAccessControlConfigurationRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val id: AccessControlConfigurationId =
      zio.aws.kendra.model.primitives.AccessControlConfigurationId(impl.id())
    override val name: Optional[AccessControlConfigurationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.kendra.model.primitives.AccessControlConfigurationName(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val accessControlList
        : Optional[List[zio.aws.kendra.model.Principal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessControlList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.Principal.wrap(item)
          }.toList
        )
    override val hierarchicalAccessControlList
        : Optional[List[zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hierarchicalAccessControlList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.HierarchicalPrincipal.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UpdateAccessControlConfigurationRequest
  ): zio.aws.kendra.model.UpdateAccessControlConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
