package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  RoleArn,
  DataSourceName,
  DataSourceId,
  LanguageCode,
  IndexId,
  Description,
  ScanSchedule
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDataSourceRequest(
    id: DataSourceId,
    name: Optional[DataSourceName] = Optional.Absent,
    indexId: IndexId,
    configuration: Optional[zio.aws.kendra.model.DataSourceConfiguration] =
      Optional.Absent,
    vpcConfiguration: Optional[
      zio.aws.kendra.model.DataSourceVpcConfiguration
    ] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    schedule: Optional[ScanSchedule] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    languageCode: Optional[LanguageCode] = Optional.Absent,
    customDocumentEnrichmentConfiguration: Optional[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UpdateDataSourceRequest = {
    import UpdateDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UpdateDataSourceRequest
      .builder()
      .id(DataSourceId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => DataSourceName.unwrap(value): java.lang.String)
      )(_.name)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        schedule.map(value => ScanSchedule.unwrap(value): java.lang.String)
      )(_.schedule)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        languageCode.map(value => LanguageCode.unwrap(value): java.lang.String)
      )(_.languageCode)
      .optionallyWith(
        customDocumentEnrichmentConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.customDocumentEnrichmentConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.UpdateDataSourceRequest.ReadOnly =
    zio.aws.kendra.model.UpdateDataSourceRequest.wrap(buildAwsValue())
}
object UpdateDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UpdateDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.UpdateDataSourceRequest =
      zio.aws.kendra.model.UpdateDataSourceRequest(
        id,
        name.map(value => value),
        indexId,
        configuration.map(value => value.asEditable),
        vpcConfiguration.map(value => value.asEditable),
        description.map(value => value),
        schedule.map(value => value),
        roleArn.map(value => value),
        languageCode.map(value => value),
        customDocumentEnrichmentConfiguration.map(value => value.asEditable)
      )
    def id: DataSourceId
    def name: Optional[DataSourceName]
    def indexId: IndexId
    def configuration
        : Optional[zio.aws.kendra.model.DataSourceConfiguration.ReadOnly]
    def vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly]
    def description: Optional[Description]
    def schedule: Optional[ScanSchedule]
    def roleArn: Optional[RoleArn]
    def languageCode: Optional[LanguageCode]
    def customDocumentEnrichmentConfiguration: Optional[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ]
    def getId: ZIO[Any, Nothing, DataSourceId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, DataSourceName] =
      AwsError.unwrapOptionField("name", name)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSchedule: ZIO[Any, AwsError, ScanSchedule] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getLanguageCode: ZIO[Any, AwsError, LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getCustomDocumentEnrichmentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customDocumentEnrichmentConfiguration",
      customDocumentEnrichmentConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UpdateDataSourceRequest
  ) extends zio.aws.kendra.model.UpdateDataSourceRequest.ReadOnly {
    override val id: DataSourceId =
      zio.aws.kendra.model.primitives.DataSourceId(impl.id())
    override val name: Optional[DataSourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.kendra.model.primitives.DataSourceName(value))
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val configuration
        : Optional[zio.aws.kendra.model.DataSourceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value => zio.aws.kendra.model.DataSourceConfiguration.wrap(value))
    override val vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value =>
          zio.aws.kendra.model.DataSourceVpcConfiguration.wrap(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val schedule: Optional[ScanSchedule] = zio.aws.core.internal
      .optionalFromNullable(impl.schedule())
      .map(value => zio.aws.kendra.model.primitives.ScanSchedule(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val languageCode: Optional[LanguageCode] = zio.aws.core.internal
      .optionalFromNullable(impl.languageCode())
      .map(value => zio.aws.kendra.model.primitives.LanguageCode(value))
    override val customDocumentEnrichmentConfiguration: Optional[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customDocumentEnrichmentConfiguration())
      .map(value =>
        zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UpdateDataSourceRequest
  ): zio.aws.kendra.model.UpdateDataSourceRequest.ReadOnly = new Wrapper(impl)
}
