package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  QueryText,
  FeaturedResultsSetName,
  IndexId,
  FeaturedResultsSetId,
  FeaturedResultsSetDescription
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFeaturedResultsSetRequest(
    indexId: IndexId,
    featuredResultsSetId: FeaturedResultsSetId,
    featuredResultsSetName: Optional[FeaturedResultsSetName] = Optional.Absent,
    description: Optional[FeaturedResultsSetDescription] = Optional.Absent,
    status: Optional[zio.aws.kendra.model.FeaturedResultsSetStatus] =
      Optional.Absent,
    queryTexts: Optional[Iterable[QueryText]] = Optional.Absent,
    featuredDocuments: Optional[
      Iterable[zio.aws.kendra.model.FeaturedDocument]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UpdateFeaturedResultsSetRequest = {
    import UpdateFeaturedResultsSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UpdateFeaturedResultsSetRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .featuredResultsSetId(
        FeaturedResultsSetId.unwrap(featuredResultsSetId): java.lang.String
      )
      .optionallyWith(
        featuredResultsSetName.map(value =>
          FeaturedResultsSetName.unwrap(value): java.lang.String
        )
      )(_.featuredResultsSetName)
      .optionallyWith(
        description.map(value =>
          FeaturedResultsSetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        queryTexts.map(value =>
          value.map { item =>
            QueryText.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.queryTexts)
      .optionallyWith(
        featuredDocuments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.featuredDocuments)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.UpdateFeaturedResultsSetRequest.ReadOnly =
    zio.aws.kendra.model.UpdateFeaturedResultsSetRequest.wrap(buildAwsValue())
}
object UpdateFeaturedResultsSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UpdateFeaturedResultsSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.UpdateFeaturedResultsSetRequest =
      zio.aws.kendra.model.UpdateFeaturedResultsSetRequest(
        indexId,
        featuredResultsSetId,
        featuredResultsSetName.map(value => value),
        description.map(value => value),
        status.map(value => value),
        queryTexts.map(value => value),
        featuredDocuments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def indexId: IndexId
    def featuredResultsSetId: FeaturedResultsSetId
    def featuredResultsSetName: Optional[FeaturedResultsSetName]
    def description: Optional[FeaturedResultsSetDescription]
    def status: Optional[zio.aws.kendra.model.FeaturedResultsSetStatus]
    def queryTexts: Optional[List[QueryText]]
    def featuredDocuments
        : Optional[List[zio.aws.kendra.model.FeaturedDocument.ReadOnly]]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getFeaturedResultsSetId: ZIO[Any, Nothing, FeaturedResultsSetId] =
      ZIO.succeed(featuredResultsSetId)
    def getFeaturedResultsSetName: ZIO[Any, AwsError, FeaturedResultsSetName] =
      AwsError.unwrapOptionField(
        "featuredResultsSetName",
        featuredResultsSetName
      )
    def getDescription: ZIO[Any, AwsError, FeaturedResultsSetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.kendra.model.FeaturedResultsSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getQueryTexts: ZIO[Any, AwsError, List[QueryText]] =
      AwsError.unwrapOptionField("queryTexts", queryTexts)
    def getFeaturedDocuments: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.FeaturedDocument.ReadOnly
    ]] = AwsError.unwrapOptionField("featuredDocuments", featuredDocuments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UpdateFeaturedResultsSetRequest
  ) extends zio.aws.kendra.model.UpdateFeaturedResultsSetRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val featuredResultsSetId: FeaturedResultsSetId =
      zio.aws.kendra.model.primitives
        .FeaturedResultsSetId(impl.featuredResultsSetId())
    override val featuredResultsSetName: Optional[FeaturedResultsSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featuredResultsSetName())
        .map(value =>
          zio.aws.kendra.model.primitives.FeaturedResultsSetName(value)
        )
    override val description: Optional[FeaturedResultsSetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.kendra.model.primitives.FeaturedResultsSetDescription(value)
        )
    override val status
        : Optional[zio.aws.kendra.model.FeaturedResultsSetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.kendra.model.FeaturedResultsSetStatus.wrap(value))
    override val queryTexts: Optional[List[QueryText]] = zio.aws.core.internal
      .optionalFromNullable(impl.queryTexts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives.QueryText(item)
        }.toList
      )
    override val featuredDocuments
        : Optional[List[zio.aws.kendra.model.FeaturedDocument.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featuredDocuments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.FeaturedDocument.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UpdateFeaturedResultsSetRequest
  ): zio.aws.kendra.model.UpdateFeaturedResultsSetRequest.ReadOnly =
    new Wrapper(impl)
}
