package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFeaturedResultsSetResponse(
    featuredResultsSet: Optional[zio.aws.kendra.model.FeaturedResultsSet] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UpdateFeaturedResultsSetResponse = {
    import UpdateFeaturedResultsSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UpdateFeaturedResultsSetResponse
      .builder()
      .optionallyWith(featuredResultsSet.map(value => value.buildAwsValue()))(
        _.featuredResultsSet
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.UpdateFeaturedResultsSetResponse.ReadOnly =
    zio.aws.kendra.model.UpdateFeaturedResultsSetResponse.wrap(buildAwsValue())
}
object UpdateFeaturedResultsSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UpdateFeaturedResultsSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.UpdateFeaturedResultsSetResponse =
      zio.aws.kendra.model.UpdateFeaturedResultsSetResponse(
        featuredResultsSet.map(value => value.asEditable)
      )
    def featuredResultsSet
        : Optional[zio.aws.kendra.model.FeaturedResultsSet.ReadOnly]
    def getFeaturedResultsSet
        : ZIO[Any, AwsError, zio.aws.kendra.model.FeaturedResultsSet.ReadOnly] =
      AwsError.unwrapOptionField("featuredResultsSet", featuredResultsSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UpdateFeaturedResultsSetResponse
  ) extends zio.aws.kendra.model.UpdateFeaturedResultsSetResponse.ReadOnly {
    override val featuredResultsSet
        : Optional[zio.aws.kendra.model.FeaturedResultsSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featuredResultsSet())
        .map(value => zio.aws.kendra.model.FeaturedResultsSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UpdateFeaturedResultsSetResponse
  ): zio.aws.kendra.model.UpdateFeaturedResultsSetResponse.ReadOnly =
    new Wrapper(impl)
}
