package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  Description,
  RoleArn,
  IndexName,
  IndexId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateIndexRequest(
    id: IndexId,
    name: Optional[IndexName] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    documentMetadataConfigurationUpdates: Optional[
      Iterable[zio.aws.kendra.model.DocumentMetadataConfiguration]
    ] = Optional.Absent,
    capacityUnits: Optional[zio.aws.kendra.model.CapacityUnitsConfiguration] =
      Optional.Absent,
    userTokenConfigurations: Optional[
      Iterable[zio.aws.kendra.model.UserTokenConfiguration]
    ] = Optional.Absent,
    userContextPolicy: Optional[zio.aws.kendra.model.UserContextPolicy] =
      Optional.Absent,
    userGroupResolutionConfiguration: Optional[
      zio.aws.kendra.model.UserGroupResolutionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UpdateIndexRequest = {
    import UpdateIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UpdateIndexRequest
      .builder()
      .id(IndexId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        documentMetadataConfigurationUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentMetadataConfigurationUpdates)
      .optionallyWith(capacityUnits.map(value => value.buildAwsValue()))(
        _.capacityUnits
      )
      .optionallyWith(
        userTokenConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userTokenConfigurations)
      .optionallyWith(userContextPolicy.map(value => value.unwrap))(
        _.userContextPolicy
      )
      .optionallyWith(
        userGroupResolutionConfiguration.map(value => value.buildAwsValue())
      )(_.userGroupResolutionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.UpdateIndexRequest.ReadOnly =
    zio.aws.kendra.model.UpdateIndexRequest.wrap(buildAwsValue())
}
object UpdateIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UpdateIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.UpdateIndexRequest =
      zio.aws.kendra.model.UpdateIndexRequest(
        id,
        name.map(value => value),
        roleArn.map(value => value),
        description.map(value => value),
        documentMetadataConfigurationUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        capacityUnits.map(value => value.asEditable),
        userTokenConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userContextPolicy.map(value => value),
        userGroupResolutionConfiguration.map(value => value.asEditable)
      )
    def id: IndexId
    def name: Optional[IndexName]
    def roleArn: Optional[RoleArn]
    def description: Optional[Description]
    def documentMetadataConfigurationUpdates: Optional[
      List[zio.aws.kendra.model.DocumentMetadataConfiguration.ReadOnly]
    ]
    def capacityUnits
        : Optional[zio.aws.kendra.model.CapacityUnitsConfiguration.ReadOnly]
    def userTokenConfigurations
        : Optional[List[zio.aws.kendra.model.UserTokenConfiguration.ReadOnly]]
    def userContextPolicy: Optional[zio.aws.kendra.model.UserContextPolicy]
    def userGroupResolutionConfiguration: Optional[
      zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly
    ]
    def getId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("name", name)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDocumentMetadataConfigurationUpdates: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DocumentMetadataConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "documentMetadataConfigurationUpdates",
      documentMetadataConfigurationUpdates
    )
    def getCapacityUnits: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.CapacityUnitsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("capacityUnits", capacityUnits)
    def getUserTokenConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.UserTokenConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "userTokenConfigurations",
      userTokenConfigurations
    )
    def getUserContextPolicy
        : ZIO[Any, AwsError, zio.aws.kendra.model.UserContextPolicy] =
      AwsError.unwrapOptionField("userContextPolicy", userContextPolicy)
    def getUserGroupResolutionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "userGroupResolutionConfiguration",
      userGroupResolutionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UpdateIndexRequest
  ) extends zio.aws.kendra.model.UpdateIndexRequest.ReadOnly {
    override val id: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.id())
    override val name: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.kendra.model.primitives.IndexName(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val documentMetadataConfigurationUpdates: Optional[
      List[zio.aws.kendra.model.DocumentMetadataConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.documentMetadataConfigurationUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DocumentMetadataConfiguration.wrap(item)
        }.toList
      )
    override val capacityUnits
        : Optional[zio.aws.kendra.model.CapacityUnitsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityUnits())
        .map(value =>
          zio.aws.kendra.model.CapacityUnitsConfiguration.wrap(value)
        )
    override val userTokenConfigurations
        : Optional[List[zio.aws.kendra.model.UserTokenConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userTokenConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.UserTokenConfiguration.wrap(item)
          }.toList
        )
    override val userContextPolicy
        : Optional[zio.aws.kendra.model.UserContextPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userContextPolicy())
        .map(value => zio.aws.kendra.model.UserContextPolicy.wrap(value))
    override val userGroupResolutionConfiguration: Optional[
      zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userGroupResolutionConfiguration())
      .map(value =>
        zio.aws.kendra.model.UserGroupResolutionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UpdateIndexRequest
  ): zio.aws.kendra.model.UpdateIndexRequest.ReadOnly = new Wrapper(impl)
}
