package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  RoleArn,
  IndexId,
  Description,
  ThesaurusName,
  ThesaurusId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateThesaurusRequest(
    id: ThesaurusId,
    name: Optional[ThesaurusName] = Optional.Absent,
    indexId: IndexId,
    description: Optional[Description] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    sourceS3Path: Optional[zio.aws.kendra.model.S3Path] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UpdateThesaurusRequest = {
    import UpdateThesaurusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UpdateThesaurusRequest
      .builder()
      .id(ThesaurusId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => ThesaurusName.unwrap(value): java.lang.String)
      )(_.name)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(sourceS3Path.map(value => value.buildAwsValue()))(
        _.sourceS3Path
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.UpdateThesaurusRequest.ReadOnly =
    zio.aws.kendra.model.UpdateThesaurusRequest.wrap(buildAwsValue())
}
object UpdateThesaurusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UpdateThesaurusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.UpdateThesaurusRequest =
      zio.aws.kendra.model.UpdateThesaurusRequest(
        id,
        name.map(value => value),
        indexId,
        description.map(value => value),
        roleArn.map(value => value),
        sourceS3Path.map(value => value.asEditable)
      )
    def id: ThesaurusId
    def name: Optional[ThesaurusName]
    def indexId: IndexId
    def description: Optional[Description]
    def roleArn: Optional[RoleArn]
    def sourceS3Path: Optional[zio.aws.kendra.model.S3Path.ReadOnly]
    def getId: ZIO[Any, Nothing, ThesaurusId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, ThesaurusName] =
      AwsError.unwrapOptionField("name", name)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getSourceS3Path
        : ZIO[Any, AwsError, zio.aws.kendra.model.S3Path.ReadOnly] =
      AwsError.unwrapOptionField("sourceS3Path", sourceS3Path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UpdateThesaurusRequest
  ) extends zio.aws.kendra.model.UpdateThesaurusRequest.ReadOnly {
    override val id: ThesaurusId =
      zio.aws.kendra.model.primitives.ThesaurusId(impl.id())
    override val name: Optional[ThesaurusName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.kendra.model.primitives.ThesaurusName(value))
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val sourceS3Path: Optional[zio.aws.kendra.model.S3Path.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceS3Path())
        .map(value => zio.aws.kendra.model.S3Path.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UpdateThesaurusRequest
  ): zio.aws.kendra.model.UpdateThesaurusRequest.ReadOnly = new Wrapper(impl)
}
