package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{PrincipalName, Token}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UserContext(
    token: Optional[Token] = Optional.Absent,
    userId: Optional[PrincipalName] = Optional.Absent,
    groups: Optional[Iterable[PrincipalName]] = Optional.Absent,
    dataSourceGroups: Optional[Iterable[zio.aws.kendra.model.DataSourceGroup]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UserContext = {
    import UserContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UserContext
      .builder()
      .optionallyWith(
        token.map(value => Token.unwrap(value): java.lang.String)
      )(_.token)
      .optionallyWith(
        userId.map(value => PrincipalName.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            PrincipalName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(
        dataSourceGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataSourceGroups)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.UserContext.ReadOnly =
    zio.aws.kendra.model.UserContext.wrap(buildAwsValue())
}
object UserContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UserContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.UserContext =
      zio.aws.kendra.model.UserContext(
        token.map(value => value),
        userId.map(value => value),
        groups.map(value => value),
        dataSourceGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def token: Optional[Token]
    def userId: Optional[PrincipalName]
    def groups: Optional[List[PrincipalName]]
    def dataSourceGroups
        : Optional[List[zio.aws.kendra.model.DataSourceGroup.ReadOnly]]
    def getToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("token", token)
    def getUserId: ZIO[Any, AwsError, PrincipalName] =
      AwsError.unwrapOptionField("userId", userId)
    def getGroups: ZIO[Any, AwsError, List[PrincipalName]] =
      AwsError.unwrapOptionField("groups", groups)
    def getDataSourceGroups: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("dataSourceGroups", dataSourceGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UserContext
  ) extends zio.aws.kendra.model.UserContext.ReadOnly {
    override val token: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.token())
      .map(value => zio.aws.kendra.model.primitives.Token(value))
    override val userId: Optional[PrincipalName] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.kendra.model.primitives.PrincipalName(value))
    override val groups: Optional[List[PrincipalName]] = zio.aws.core.internal
      .optionalFromNullable(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives.PrincipalName(item)
        }.toList
      )
    override val dataSourceGroups
        : Optional[List[zio.aws.kendra.model.DataSourceGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSourceGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.DataSourceGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UserContext
  ): zio.aws.kendra.model.UserContext.ReadOnly = new Wrapper(impl)
}
