package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait UserContextPolicy {
  def unwrap: software.amazon.awssdk.services.kendra.model.UserContextPolicy
}
object UserContextPolicy {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.UserContextPolicy
  ): zio.aws.kendra.model.UserContextPolicy = value match {
    case software.amazon.awssdk.services.kendra.model.UserContextPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.UserContextPolicy.ATTRIBUTE_FILTER =>
      val r = ATTRIBUTE_FILTER
      r
    case software.amazon.awssdk.services.kendra.model.UserContextPolicy.USER_TOKEN =>
      val r = USER_TOKEN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.UserContextPolicy {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.UserContextPolicy =
      software.amazon.awssdk.services.kendra.model.UserContextPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object ATTRIBUTE_FILTER extends zio.aws.kendra.model.UserContextPolicy {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.UserContextPolicy =
      software.amazon.awssdk.services.kendra.model.UserContextPolicy.ATTRIBUTE_FILTER
  }
  case object USER_TOKEN extends zio.aws.kendra.model.UserContextPolicy {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.UserContextPolicy =
      software.amazon.awssdk.services.kendra.model.UserContextPolicy.USER_TOKEN
  }
}
