package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UserGroupResolutionConfiguration(
    userGroupResolutionMode: zio.aws.kendra.model.UserGroupResolutionMode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UserGroupResolutionConfiguration = {
    import UserGroupResolutionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UserGroupResolutionConfiguration
      .builder()
      .userGroupResolutionMode(userGroupResolutionMode.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly =
    zio.aws.kendra.model.UserGroupResolutionConfiguration.wrap(buildAwsValue())
}
object UserGroupResolutionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UserGroupResolutionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.UserGroupResolutionConfiguration =
      zio.aws.kendra.model
        .UserGroupResolutionConfiguration(userGroupResolutionMode)
    def userGroupResolutionMode: zio.aws.kendra.model.UserGroupResolutionMode
    def getUserGroupResolutionMode
        : ZIO[Any, Nothing, zio.aws.kendra.model.UserGroupResolutionMode] =
      ZIO.succeed(userGroupResolutionMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UserGroupResolutionConfiguration
  ) extends zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly {
    override val userGroupResolutionMode
        : zio.aws.kendra.model.UserGroupResolutionMode =
      zio.aws.kendra.model.UserGroupResolutionMode
        .wrap(impl.userGroupResolutionMode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UserGroupResolutionConfiguration
  ): zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly =
    new Wrapper(impl)
}
