package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.IdentityAttributeName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UserIdentityConfiguration(
    identityAttributeName: Optional[IdentityAttributeName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UserIdentityConfiguration = {
    import UserIdentityConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UserIdentityConfiguration
      .builder()
      .optionallyWith(
        identityAttributeName.map(value =>
          IdentityAttributeName.unwrap(value): java.lang.String
        )
      )(_.identityAttributeName)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.UserIdentityConfiguration.ReadOnly =
    zio.aws.kendra.model.UserIdentityConfiguration.wrap(buildAwsValue())
}
object UserIdentityConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UserIdentityConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.UserIdentityConfiguration =
      zio.aws.kendra.model
        .UserIdentityConfiguration(identityAttributeName.map(value => value))
    def identityAttributeName: Optional[IdentityAttributeName]
    def getIdentityAttributeName: ZIO[Any, AwsError, IdentityAttributeName] =
      AwsError.unwrapOptionField("identityAttributeName", identityAttributeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UserIdentityConfiguration
  ) extends zio.aws.kendra.model.UserIdentityConfiguration.ReadOnly {
    override val identityAttributeName: Optional[IdentityAttributeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityAttributeName())
        .map(value =>
          zio.aws.kendra.model.primitives.IdentityAttributeName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UserIdentityConfiguration
  ): zio.aws.kendra.model.UserIdentityConfiguration.ReadOnly = new Wrapper(impl)
}
