package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait WarningCode {
  def unwrap: software.amazon.awssdk.services.kendra.model.WarningCode
}
object WarningCode {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.WarningCode
  ): zio.aws.kendra.model.WarningCode = value match {
    case software.amazon.awssdk.services.kendra.model.WarningCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.WarningCode.QUERY_LANGUAGE_INVALID_SYNTAX =>
      val r = QUERY_LANGUAGE_INVALID_SYNTAX
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.WarningCode {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.WarningCode =
      software.amazon.awssdk.services.kendra.model.WarningCode.UNKNOWN_TO_SDK_VERSION
  }
  case object QUERY_LANGUAGE_INVALID_SYNTAX
      extends zio.aws.kendra.model.WarningCode {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.WarningCode =
      software.amazon.awssdk.services.kendra.model.WarningCode.QUERY_LANGUAGE_INVALID_SYNTAX
  }
}
