package zio.aws.kendra.model
import scala.jdk.CollectionConverters.*
sealed trait WebCrawlerMode {
  def unwrap: software.amazon.awssdk.services.kendra.model.WebCrawlerMode
}
object WebCrawlerMode {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.WebCrawlerMode
  ): zio.aws.kendra.model.WebCrawlerMode = value match {
    case software.amazon.awssdk.services.kendra.model.WebCrawlerMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.WebCrawlerMode.HOST_ONLY =>
      val r = HOST_ONLY
      r
    case software.amazon.awssdk.services.kendra.model.WebCrawlerMode.SUBDOMAINS =>
      val r = SUBDOMAINS
      r
    case software.amazon.awssdk.services.kendra.model.WebCrawlerMode.EVERYTHING =>
      val r = EVERYTHING
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.WebCrawlerMode {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.WebCrawlerMode =
      software.amazon.awssdk.services.kendra.model.WebCrawlerMode.UNKNOWN_TO_SDK_VERSION
  }
  case object HOST_ONLY extends zio.aws.kendra.model.WebCrawlerMode {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.WebCrawlerMode =
      software.amazon.awssdk.services.kendra.model.WebCrawlerMode.HOST_ONLY
  }
  case object SUBDOMAINS extends zio.aws.kendra.model.WebCrawlerMode {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.WebCrawlerMode =
      software.amazon.awssdk.services.kendra.model.WebCrawlerMode.SUBDOMAINS
  }
  case object EVERYTHING extends zio.aws.kendra.model.WebCrawlerMode {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.WebCrawlerMode =
      software.amazon.awssdk.services.kendra.model.WebCrawlerMode.EVERYTHING
  }
}
