package zio.aws.kendra
import zio.prelude.Subtype
import zio.Chunk
import zio.aws.kendra.model.primitives.{
  SubnetId,
  MimeType,
  QueryText,
  DataSourceId,
  ConfluenceSpaceIdentifier,
  FaqId,
  Importance,
  Url,
  ValueImportanceMapKey,
  UserAccount,
  RepositoryName,
  SharedDriveId,
  ColumnName,
  SiteMap,
  DataSourceInclusionsExclusionsStringsMember,
  FolderId,
  EntityId,
  VpcSecurityGroupId,
  OneDriveUser,
  FeaturedResultsSetId,
  SeedUrl,
  PrincipalName,
  DocumentAttributeKey,
  DocumentId,
  TagKey
}
import java.time.Instant
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AccessControlConfigurationId extends zio.prelude.Subtype[String]
    type AccessControlConfigurationId =
      zio.aws.kendra.model.primitives.AccessControlConfigurationId.Type
    object AccessControlConfigurationName extends zio.prelude.Subtype[String]
    type AccessControlConfigurationName =
      zio.aws.kendra.model.primitives.AccessControlConfigurationName.Type
    object AmazonResourceName extends zio.prelude.Subtype[String]
    type AmazonResourceName =
      zio.aws.kendra.model.primitives.AmazonResourceName.Type
    object Blob extends zio.prelude.Subtype[Chunk[Byte]]
    type Blob = zio.aws.kendra.model.primitives.Blob.Type
    object ClaimRegex extends zio.prelude.Subtype[String]
    type ClaimRegex = zio.aws.kendra.model.primitives.ClaimRegex.Type
    object ClientTokenName extends zio.prelude.Subtype[String]
    type ClientTokenName = zio.aws.kendra.model.primitives.ClientTokenName.Type
    object ColumnName extends zio.prelude.Subtype[String]
    type ColumnName = zio.aws.kendra.model.primitives.ColumnName.Type
    object ConfluenceSpaceIdentifier extends zio.prelude.Subtype[String]
    type ConfluenceSpaceIdentifier =
      zio.aws.kendra.model.primitives.ConfluenceSpaceIdentifier.Type
    object Content extends zio.prelude.Subtype[String]
    type Content = zio.aws.kendra.model.primitives.Content.Type
    object CrawlDepth extends zio.prelude.Subtype[Int]
    type CrawlDepth = zio.aws.kendra.model.primitives.CrawlDepth.Type
    object DataSourceDateFieldFormat extends zio.prelude.Subtype[String]
    type DataSourceDateFieldFormat =
      zio.aws.kendra.model.primitives.DataSourceDateFieldFormat.Type
    object DataSourceFieldName extends zio.prelude.Subtype[String]
    type DataSourceFieldName =
      zio.aws.kendra.model.primitives.DataSourceFieldName.Type
    object DataSourceId extends zio.prelude.Subtype[String]
    type DataSourceId = zio.aws.kendra.model.primitives.DataSourceId.Type
    object DataSourceInclusionsExclusionsStringsMember
        extends zio.prelude.Subtype[String]
    type DataSourceInclusionsExclusionsStringsMember =
      zio.aws.kendra.model.primitives.DataSourceInclusionsExclusionsStringsMember.Type
    object DataSourceName extends zio.prelude.Subtype[String]
    type DataSourceName = zio.aws.kendra.model.primitives.DataSourceName.Type
    object DataSourceSyncJobId extends zio.prelude.Subtype[String]
    type DataSourceSyncJobId =
      zio.aws.kendra.model.primitives.DataSourceSyncJobId.Type
    object DatabaseHost extends zio.prelude.Subtype[String]
    type DatabaseHost = zio.aws.kendra.model.primitives.DatabaseHost.Type
    object DatabaseName extends zio.prelude.Subtype[String]
    type DatabaseName = zio.aws.kendra.model.primitives.DatabaseName.Type
    object DatabasePort extends zio.prelude.Subtype[Int]
    type DatabasePort = zio.aws.kendra.model.primitives.DatabasePort.Type
    object Description extends zio.prelude.Subtype[String]
    type Description = zio.aws.kendra.model.primitives.Description.Type
    object DocumentAttributeKey extends zio.prelude.Subtype[String]
    type DocumentAttributeKey =
      zio.aws.kendra.model.primitives.DocumentAttributeKey.Type
    object DocumentAttributeStringValue extends zio.prelude.Subtype[String]
    type DocumentAttributeStringValue =
      zio.aws.kendra.model.primitives.DocumentAttributeStringValue.Type
    object DocumentId extends zio.prelude.Subtype[String]
    type DocumentId = zio.aws.kendra.model.primitives.DocumentId.Type
    object DocumentMetadataBoolean extends zio.prelude.Subtype[Boolean]
    type DocumentMetadataBoolean =
      zio.aws.kendra.model.primitives.DocumentMetadataBoolean.Type
    object DocumentMetadataConfigurationName extends zio.prelude.Subtype[String]
    type DocumentMetadataConfigurationName =
      zio.aws.kendra.model.primitives.DocumentMetadataConfigurationName.Type
    object DocumentTitle extends zio.prelude.Subtype[String]
    type DocumentTitle = zio.aws.kendra.model.primitives.DocumentTitle.Type
    object Domain extends zio.prelude.Subtype[String]
    type Domain = zio.aws.kendra.model.primitives.Domain.Type
    object Duration extends zio.prelude.Subtype[String]
    type Duration = zio.aws.kendra.model.primitives.Duration.Type
    object Endpoint extends zio.prelude.Subtype[String]
    type Endpoint = zio.aws.kendra.model.primitives.Endpoint.Type
    object EnterpriseId extends zio.prelude.Subtype[String]
    type EnterpriseId = zio.aws.kendra.model.primitives.EnterpriseId.Type
    object EntityId extends zio.prelude.Subtype[String]
    type EntityId = zio.aws.kendra.model.primitives.EntityId.Type
    object ErrorMessage extends zio.prelude.Subtype[String]
    type ErrorMessage = zio.aws.kendra.model.primitives.ErrorMessage.Type
    object ExperienceId extends zio.prelude.Subtype[String]
    type ExperienceId = zio.aws.kendra.model.primitives.ExperienceId.Type
    object ExperienceName extends zio.prelude.Subtype[String]
    type ExperienceName = zio.aws.kendra.model.primitives.ExperienceName.Type
    object FailureReason extends zio.prelude.Subtype[String]
    type FailureReason = zio.aws.kendra.model.primitives.FailureReason.Type
    object FaqId extends zio.prelude.Subtype[String]
    type FaqId = zio.aws.kendra.model.primitives.FaqId.Type
    object FaqName extends zio.prelude.Subtype[String]
    type FaqName = zio.aws.kendra.model.primitives.FaqName.Type
    object FeaturedResultsSetDescription extends zio.prelude.Subtype[String]
    type FeaturedResultsSetDescription =
      zio.aws.kendra.model.primitives.FeaturedResultsSetDescription.Type
    object FeaturedResultsSetId extends zio.prelude.Subtype[String]
    type FeaturedResultsSetId =
      zio.aws.kendra.model.primitives.FeaturedResultsSetId.Type
    object FeaturedResultsSetName extends zio.prelude.Subtype[String]
    type FeaturedResultsSetName =
      zio.aws.kendra.model.primitives.FeaturedResultsSetName.Type
    object FeedbackToken extends zio.prelude.Subtype[String]
    type FeedbackToken = zio.aws.kendra.model.primitives.FeedbackToken.Type
    object FileSystemId extends zio.prelude.Subtype[String]
    type FileSystemId = zio.aws.kendra.model.primitives.FileSystemId.Type
    object FolderId extends zio.prelude.Subtype[String]
    type FolderId = zio.aws.kendra.model.primitives.FolderId.Type
    object GroupAttributeField extends zio.prelude.Subtype[String]
    type GroupAttributeField =
      zio.aws.kendra.model.primitives.GroupAttributeField.Type
    object GroupId extends zio.prelude.Subtype[String]
    type GroupId = zio.aws.kendra.model.primitives.GroupId.Type
    object Host extends zio.prelude.Subtype[String]
    type Host = zio.aws.kendra.model.primitives.Host.Type
    object IdentityAttributeName extends zio.prelude.Subtype[String]
    type IdentityAttributeName =
      zio.aws.kendra.model.primitives.IdentityAttributeName.Type
    object Importance extends zio.prelude.Subtype[Int]
    type Importance = zio.aws.kendra.model.primitives.Importance.Type
    object IndexFieldName extends zio.prelude.Subtype[String]
    type IndexFieldName = zio.aws.kendra.model.primitives.IndexFieldName.Type
    object IndexId extends zio.prelude.Subtype[String]
    type IndexId = zio.aws.kendra.model.primitives.IndexId.Type
    object IndexName extends zio.prelude.Subtype[String]
    type IndexName = zio.aws.kendra.model.primitives.IndexName.Type
    object IndexedQuestionAnswersCount extends zio.prelude.Subtype[Int]
    type IndexedQuestionAnswersCount =
      zio.aws.kendra.model.primitives.IndexedQuestionAnswersCount.Type
    object IndexedTextBytes extends zio.prelude.Subtype[Long]
    type IndexedTextBytes =
      zio.aws.kendra.model.primitives.IndexedTextBytes.Type
    object IndexedTextDocumentsCount extends zio.prelude.Subtype[Int]
    type IndexedTextDocumentsCount =
      zio.aws.kendra.model.primitives.IndexedTextDocumentsCount.Type
    type Integer = Int
    object Issuer extends zio.prelude.Subtype[String]
    type Issuer = zio.aws.kendra.model.primitives.Issuer.Type
    object JiraAccountUrl extends zio.prelude.Subtype[String]
    type JiraAccountUrl = zio.aws.kendra.model.primitives.JiraAccountUrl.Type
    object KmsKeyId extends zio.prelude.Subtype[String]
    type KmsKeyId = zio.aws.kendra.model.primitives.KmsKeyId.Type
    object LambdaArn extends zio.prelude.Subtype[String]
    type LambdaArn = zio.aws.kendra.model.primitives.LambdaArn.Type
    object LanguageCode extends zio.prelude.Subtype[String]
    type LanguageCode = zio.aws.kendra.model.primitives.LanguageCode.Type
    object LookBackPeriod extends zio.prelude.Subtype[Int]
    type LookBackPeriod = zio.aws.kendra.model.primitives.LookBackPeriod.Type
    object MaxContentSizePerPageInMegaBytes extends zio.prelude.Subtype[Float]
    type MaxContentSizePerPageInMegaBytes =
      zio.aws.kendra.model.primitives.MaxContentSizePerPageInMegaBytes.Type
    object MaxLinksPerPage extends zio.prelude.Subtype[Int]
    type MaxLinksPerPage = zio.aws.kendra.model.primitives.MaxLinksPerPage.Type
    object MaxResultsIntegerForListAccessControlConfigurationsRequest
        extends zio.prelude.Subtype[Int]
    type MaxResultsIntegerForListAccessControlConfigurationsRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListAccessControlConfigurationsRequest.Type
    object MaxResultsIntegerForListDataSourceSyncJobsRequest
        extends zio.prelude.Subtype[Int]
    type MaxResultsIntegerForListDataSourceSyncJobsRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListDataSourceSyncJobsRequest.Type
    object MaxResultsIntegerForListDataSourcesRequest
        extends zio.prelude.Subtype[Int]
    type MaxResultsIntegerForListDataSourcesRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListDataSourcesRequest.Type
    object MaxResultsIntegerForListEntityPersonasRequest
        extends zio.prelude.Subtype[Int]
    type MaxResultsIntegerForListEntityPersonasRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListEntityPersonasRequest.Type
    object MaxResultsIntegerForListExperiencesRequest
        extends zio.prelude.Subtype[Int]
    type MaxResultsIntegerForListExperiencesRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListExperiencesRequest.Type
    object MaxResultsIntegerForListFaqsRequest extends zio.prelude.Subtype[Int]
    type MaxResultsIntegerForListFaqsRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListFaqsRequest.Type
    object MaxResultsIntegerForListFeaturedResultsSetsRequest
        extends zio.prelude.Subtype[Int]
    type MaxResultsIntegerForListFeaturedResultsSetsRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListFeaturedResultsSetsRequest.Type
    object MaxResultsIntegerForListIndicesRequest
        extends zio.prelude.Subtype[Int]
    type MaxResultsIntegerForListIndicesRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListIndicesRequest.Type
    object MaxResultsIntegerForListPrincipalsRequest
        extends zio.prelude.Subtype[Int]
    type MaxResultsIntegerForListPrincipalsRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListPrincipalsRequest.Type
    object MaxResultsIntegerForListQuerySuggestionsBlockLists
        extends zio.prelude.Subtype[Int]
    type MaxResultsIntegerForListQuerySuggestionsBlockLists =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListQuerySuggestionsBlockLists.Type
    object MaxResultsIntegerForListThesauriRequest
        extends zio.prelude.Subtype[Int]
    type MaxResultsIntegerForListThesauriRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListThesauriRequest.Type
    object MaxUrlsPerMinuteCrawlRate extends zio.prelude.Subtype[Int]
    type MaxUrlsPerMinuteCrawlRate =
      zio.aws.kendra.model.primitives.MaxUrlsPerMinuteCrawlRate.Type
    object MetricValue extends zio.prelude.Subtype[String]
    type MetricValue = zio.aws.kendra.model.primitives.MetricValue.Type
    object MimeType extends zio.prelude.Subtype[String]
    type MimeType = zio.aws.kendra.model.primitives.MimeType.Type
    object MinimumNumberOfQueryingUsers extends zio.prelude.Subtype[Int]
    type MinimumNumberOfQueryingUsers =
      zio.aws.kendra.model.primitives.MinimumNumberOfQueryingUsers.Type
    object MinimumQueryCount extends zio.prelude.Subtype[Int]
    type MinimumQueryCount =
      zio.aws.kendra.model.primitives.MinimumQueryCount.Type
    object NameType extends zio.prelude.Subtype[String]
    type NameType = zio.aws.kendra.model.primitives.NameType.Type
    object NextToken extends zio.prelude.Subtype[String]
    type NextToken = zio.aws.kendra.model.primitives.NextToken.Type
    object ObjectBoolean extends zio.prelude.Subtype[Boolean]
    type ObjectBoolean = zio.aws.kendra.model.primitives.ObjectBoolean.Type
    object OneDriveUser extends zio.prelude.Subtype[String]
    type OneDriveUser = zio.aws.kendra.model.primitives.OneDriveUser.Type
    object OrganizationId extends zio.prelude.Subtype[String]
    type OrganizationId = zio.aws.kendra.model.primitives.OrganizationId.Type
    object OrganizationName extends zio.prelude.Subtype[String]
    type OrganizationName =
      zio.aws.kendra.model.primitives.OrganizationName.Type
    object Port extends zio.prelude.Subtype[Int]
    type Port = zio.aws.kendra.model.primitives.Port.Type
    object PrincipalName extends zio.prelude.Subtype[String]
    type PrincipalName = zio.aws.kendra.model.primitives.PrincipalName.Type
    object PrincipalOrderingId extends zio.prelude.Subtype[Long]
    type PrincipalOrderingId =
      zio.aws.kendra.model.primitives.PrincipalOrderingId.Type
    object QueryCapacityUnit extends zio.prelude.Subtype[Int]
    type QueryCapacityUnit =
      zio.aws.kendra.model.primitives.QueryCapacityUnit.Type
    object QueryId extends zio.prelude.Subtype[String]
    type QueryId = zio.aws.kendra.model.primitives.QueryId.Type
    object QuerySuggestionsBlockListId extends zio.prelude.Subtype[String]
    type QuerySuggestionsBlockListId =
      zio.aws.kendra.model.primitives.QuerySuggestionsBlockListId.Type
    object QuerySuggestionsBlockListName extends zio.prelude.Subtype[String]
    type QuerySuggestionsBlockListName =
      zio.aws.kendra.model.primitives.QuerySuggestionsBlockListName.Type
    object QuerySuggestionsId extends zio.prelude.Subtype[String]
    type QuerySuggestionsId =
      zio.aws.kendra.model.primitives.QuerySuggestionsId.Type
    object QueryText extends zio.prelude.Subtype[String]
    type QueryText = zio.aws.kendra.model.primitives.QueryText.Type
    object RepositoryName extends zio.prelude.Subtype[String]
    type RepositoryName = zio.aws.kendra.model.primitives.RepositoryName.Type
    object ResultId extends zio.prelude.Subtype[String]
    type ResultId = zio.aws.kendra.model.primitives.ResultId.Type
    object RoleArn extends zio.prelude.Subtype[String]
    type RoleArn = zio.aws.kendra.model.primitives.RoleArn.Type
    object S3BucketName extends zio.prelude.Subtype[String]
    type S3BucketName = zio.aws.kendra.model.primitives.S3BucketName.Type
    object S3ObjectKey extends zio.prelude.Subtype[String]
    type S3ObjectKey = zio.aws.kendra.model.primitives.S3ObjectKey.Type
    object SalesforceCustomKnowledgeArticleTypeName
        extends zio.prelude.Subtype[String]
    type SalesforceCustomKnowledgeArticleTypeName =
      zio.aws.kendra.model.primitives.SalesforceCustomKnowledgeArticleTypeName.Type
    object ScanSchedule extends zio.prelude.Subtype[String]
    type ScanSchedule = zio.aws.kendra.model.primitives.ScanSchedule.Type
    object SecretArn extends zio.prelude.Subtype[String]
    type SecretArn = zio.aws.kendra.model.primitives.SecretArn.Type
    object SeedUrl extends zio.prelude.Subtype[String]
    type SeedUrl = zio.aws.kendra.model.primitives.SeedUrl.Type
    object ServiceNowHostUrl extends zio.prelude.Subtype[String]
    type ServiceNowHostUrl =
      zio.aws.kendra.model.primitives.ServiceNowHostUrl.Type
    object ServiceNowKnowledgeArticleFilterQuery
        extends zio.prelude.Subtype[String]
    type ServiceNowKnowledgeArticleFilterQuery =
      zio.aws.kendra.model.primitives.ServiceNowKnowledgeArticleFilterQuery.Type
    object SharedDriveId extends zio.prelude.Subtype[String]
    type SharedDriveId = zio.aws.kendra.model.primitives.SharedDriveId.Type
    object SinceCrawlDate extends zio.prelude.Subtype[String]
    type SinceCrawlDate = zio.aws.kendra.model.primitives.SinceCrawlDate.Type
    object SiteId extends zio.prelude.Subtype[String]
    type SiteId = zio.aws.kendra.model.primitives.SiteId.Type
    object SiteMap extends zio.prelude.Subtype[String]
    type SiteMap = zio.aws.kendra.model.primitives.SiteMap.Type
    object SiteUrl extends zio.prelude.Subtype[String]
    type SiteUrl = zio.aws.kendra.model.primitives.SiteUrl.Type
    object StorageCapacityUnit extends zio.prelude.Subtype[Int]
    type StorageCapacityUnit =
      zio.aws.kendra.model.primitives.StorageCapacityUnit.Type
    object SubnetId extends zio.prelude.Subtype[String]
    type SubnetId = zio.aws.kendra.model.primitives.SubnetId.Type
    object SuggestedQueryText extends zio.prelude.Subtype[String]
    type SuggestedQueryText =
      zio.aws.kendra.model.primitives.SuggestedQueryText.Type
    object SuggestionQueryText extends zio.prelude.Subtype[String]
    type SuggestionQueryText =
      zio.aws.kendra.model.primitives.SuggestionQueryText.Type
    object TableName extends zio.prelude.Subtype[String]
    type TableName = zio.aws.kendra.model.primitives.TableName.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.kendra.model.primitives.TagKey.Type
    object TagValue extends zio.prelude.Subtype[String]
    type TagValue = zio.aws.kendra.model.primitives.TagValue.Type
    object TeamId extends zio.prelude.Subtype[String]
    type TeamId = zio.aws.kendra.model.primitives.TeamId.Type
    object TenantDomain extends zio.prelude.Subtype[String]
    type TenantDomain = zio.aws.kendra.model.primitives.TenantDomain.Type
    object ThesaurusId extends zio.prelude.Subtype[String]
    type ThesaurusId = zio.aws.kendra.model.primitives.ThesaurusId.Type
    object ThesaurusName extends zio.prelude.Subtype[String]
    type ThesaurusName = zio.aws.kendra.model.primitives.ThesaurusName.Type
    object Timestamp extends zio.prelude.Subtype[Instant]
    type Timestamp = zio.aws.kendra.model.primitives.Timestamp.Type
    object Title extends zio.prelude.Subtype[String]
    type Title = zio.aws.kendra.model.primitives.Title.Type
    object Token extends zio.prelude.Subtype[String]
    type Token = zio.aws.kendra.model.primitives.Token.Type
    object TopDocumentAttributeValueCountPairsSize
        extends zio.prelude.Subtype[Int]
    type TopDocumentAttributeValueCountPairsSize =
      zio.aws.kendra.model.primitives.TopDocumentAttributeValueCountPairsSize.Type
    object Url extends zio.prelude.Subtype[String]
    type Url = zio.aws.kendra.model.primitives.Url.Type
    object UserAccount extends zio.prelude.Subtype[String]
    type UserAccount = zio.aws.kendra.model.primitives.UserAccount.Type
    object UserId extends zio.prelude.Subtype[String]
    type UserId = zio.aws.kendra.model.primitives.UserId.Type
    object UserNameAttributeField extends zio.prelude.Subtype[String]
    type UserNameAttributeField =
      zio.aws.kendra.model.primitives.UserNameAttributeField.Type
    object ValueImportanceMapKey extends zio.prelude.Subtype[String]
    type ValueImportanceMapKey =
      zio.aws.kendra.model.primitives.ValueImportanceMapKey.Type
    object VisitorId extends zio.prelude.Subtype[String]
    type VisitorId = zio.aws.kendra.model.primitives.VisitorId.Type
    object VpcSecurityGroupId extends zio.prelude.Subtype[String]
    type VpcSecurityGroupId =
      zio.aws.kendra.model.primitives.VpcSecurityGroupId.Type
    object WarningMessage extends zio.prelude.Subtype[String]
    type WarningMessage = zio.aws.kendra.model.primitives.WarningMessage.Type
  }
  type AccessControlConfigurationSummaryList =
    List[zio.aws.kendra.model.AccessControlConfigurationSummary]
  type AdditionalResultAttributeList =
    List[zio.aws.kendra.model.AdditionalResultAttribute]
  type AssociateEntitiesToExperienceFailedEntityList =
    List[zio.aws.kendra.model.FailedEntity]
  type AssociateEntityList = List[zio.aws.kendra.model.EntityConfiguration]
  type AttributeFilterList = List[zio.aws.kendra.model.AttributeFilter]
  type BasicAuthenticationConfigurationList =
    List[zio.aws.kendra.model.BasicAuthenticationConfiguration]
  type BatchDeleteDocumentResponseFailedDocuments =
    List[zio.aws.kendra.model.BatchDeleteDocumentResponseFailedDocument]
  type BatchDeleteFeaturedResultsSetErrors =
    List[zio.aws.kendra.model.BatchDeleteFeaturedResultsSetError]
  type BatchGetDocumentStatusResponseErrors =
    List[zio.aws.kendra.model.BatchGetDocumentStatusResponseError]
  type BatchPutDocumentResponseFailedDocuments =
    List[zio.aws.kendra.model.BatchPutDocumentResponseFailedDocument]
  type ChangeDetectingColumns = List[ColumnName]
  type ClickFeedbackList = List[zio.aws.kendra.model.ClickFeedback]
  type ConfluenceAttachmentFieldMappingsList =
    List[zio.aws.kendra.model.ConfluenceAttachmentToIndexFieldMapping]
  type ConfluenceBlogFieldMappingsList =
    List[zio.aws.kendra.model.ConfluenceBlogToIndexFieldMapping]
  type ConfluencePageFieldMappingsList =
    List[zio.aws.kendra.model.ConfluencePageToIndexFieldMapping]
  type ConfluenceSpaceFieldMappingsList =
    List[zio.aws.kendra.model.ConfluenceSpaceToIndexFieldMapping]
  type ConfluenceSpaceList = List[ConfluenceSpaceIdentifier]
  type CorrectionList = List[zio.aws.kendra.model.Correction]
  type DataSourceGroups = List[zio.aws.kendra.model.DataSourceGroup]
  type DataSourceIdList = List[DataSourceId]
  type DataSourceInclusionsExclusionsStrings =
    List[DataSourceInclusionsExclusionsStringsMember]
  type DataSourceSummaryList = List[zio.aws.kendra.model.DataSourceSummary]
  type DataSourceSyncJobHistoryList =
    List[zio.aws.kendra.model.DataSourceSyncJob]
  type DataSourceToIndexFieldMappingList =
    List[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
  type DisassociateEntityList = List[zio.aws.kendra.model.EntityConfiguration]
  type DocumentAttributeKeyList = List[DocumentAttributeKey]
  type DocumentAttributeList = List[zio.aws.kendra.model.DocumentAttribute]
  type DocumentAttributeStringListValue = List[String]
  type DocumentAttributeValueCountPairList =
    List[zio.aws.kendra.model.DocumentAttributeValueCountPair]
  type DocumentIdList = List[DocumentId]
  type DocumentInfoList = List[zio.aws.kendra.model.DocumentInfo]
  type DocumentList = List[zio.aws.kendra.model.Document]
  type DocumentMetadataConfigurationList =
    List[zio.aws.kendra.model.DocumentMetadataConfiguration]
  type DocumentRelevanceOverrideConfigurationList =
    List[zio.aws.kendra.model.DocumentRelevanceConfiguration]
  type DocumentStatusList = List[zio.aws.kendra.model.Status]
  type EntityFilter = List[zio.aws.kendra.model.AlfrescoEntity]
  type EntityIdsList = List[EntityId]
  type EntityPersonaConfigurationList =
    List[zio.aws.kendra.model.EntityPersonaConfiguration]
  type ExcludeMimeTypesList = List[MimeType]
  type ExcludeSharedDrivesList = List[SharedDriveId]
  type ExcludeUserAccountsList = List[UserAccount]
  type ExpandedResultList = List[zio.aws.kendra.model.ExpandedResultItem]
  type ExperienceEndpoints = List[zio.aws.kendra.model.ExperienceEndpoint]
  type ExperienceEntitiesSummaryList =
    List[zio.aws.kendra.model.ExperienceEntitiesSummary]
  type ExperiencesSummaryList = List[zio.aws.kendra.model.ExperiencesSummary]
  type FacetList = List[zio.aws.kendra.model.Facet]
  type FacetResultList = List[zio.aws.kendra.model.FacetResult]
  type FailedEntityList = List[zio.aws.kendra.model.FailedEntity]
  type FaqIdsList = List[FaqId]
  type FaqSummaryItems = List[zio.aws.kendra.model.FaqSummary]
  type FeaturedDocumentList = List[zio.aws.kendra.model.FeaturedDocument]
  type FeaturedDocumentMissingList =
    List[zio.aws.kendra.model.FeaturedDocumentMissing]
  type FeaturedDocumentWithMetadataList =
    List[zio.aws.kendra.model.FeaturedDocumentWithMetadata]
  type FeaturedResultsItemList = List[zio.aws.kendra.model.FeaturedResultsItem]
  type FeaturedResultsSetIdList = List[FeaturedResultsSetId]
  type FeaturedResultsSetSummaryItems =
    List[zio.aws.kendra.model.FeaturedResultsSetSummary]
  type FolderIdList = List[FolderId]
  type GroupOrderingIdSummaries =
    List[zio.aws.kendra.model.GroupOrderingIdSummary]
  type Groups = List[PrincipalName]
  type HierarchicalPrincipalList =
    List[zio.aws.kendra.model.HierarchicalPrincipal]
  type HighlightList = List[zio.aws.kendra.model.Highlight]
  type IndexConfigurationSummaryList =
    List[zio.aws.kendra.model.IndexConfigurationSummary]
  type InlineCustomDocumentEnrichmentConfigurationList =
    List[zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration]
  type IssueSubEntityFilter = List[zio.aws.kendra.model.IssueSubEntity]
  type IssueType = List[String]
  type JiraStatus = List[String]
  type ListOfGroupSummaries = List[zio.aws.kendra.model.GroupSummary]
  type MemberGroups = List[zio.aws.kendra.model.MemberGroup]
  type MemberUsers = List[zio.aws.kendra.model.MemberUser]
  type OneDriveUserList = List[OneDriveUser]
  type PersonasSummaryList = List[zio.aws.kendra.model.PersonasSummary]
  type PrincipalList = List[zio.aws.kendra.model.Principal]
  type PrivateChannelFilter = List[String]
  type Project = List[String]
  type PublicChannelFilter = List[String]
  type QueryResultItemList = List[zio.aws.kendra.model.QueryResultItem]
  type QuerySuggestionsBlockListSummaryItems =
    List[zio.aws.kendra.model.QuerySuggestionsBlockListSummary]
  type QueryTextList = List[QueryText]
  type RelevanceFeedbackList = List[zio.aws.kendra.model.RelevanceFeedback]
  type RepositoryNames = List[RepositoryName]
  type RetrieveResultItemList = List[zio.aws.kendra.model.RetrieveResultItem]
  type SalesforceChatterFeedIncludeFilterTypes =
    List[zio.aws.kendra.model.SalesforceChatterFeedIncludeFilterType]
  type SalesforceCustomKnowledgeArticleTypeConfigurationList =
    List[zio.aws.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration]
  type SalesforceKnowledgeArticleStateList =
    List[zio.aws.kendra.model.SalesforceKnowledgeArticleState]
  type SalesforceStandardObjectConfigurationList =
    List[zio.aws.kendra.model.SalesforceStandardObjectConfiguration]
  type SecurityGroupIdList = List[VpcSecurityGroupId]
  type SeedUrlList = List[SeedUrl]
  type SharePointUrlList = List[Url]
  type SiteMapsList = List[SiteMap]
  type SlackEntityList = List[zio.aws.kendra.model.SlackEntity]
  type SnapshotsDataHeaderFields = List[String]
  type SnapshotsDataRecord = List[String]
  type SnapshotsDataRecords = List[Iterable[String]]
  type SortingConfigurationList =
    List[zio.aws.kendra.model.SortingConfiguration]
  type SourceDocuments = List[zio.aws.kendra.model.SourceDocument]
  type SpellCorrectedQueryList = List[zio.aws.kendra.model.SpellCorrectedQuery]
  type StringList = List[String]
  type SubnetIdList = List[SubnetId]
  type SuggestableConfigList = List[zio.aws.kendra.model.SuggestableConfig]
  type SuggestionHighlightList = List[zio.aws.kendra.model.SuggestionHighlight]
  type SuggestionList = List[zio.aws.kendra.model.Suggestion]
  type SuggestionTypes = List[zio.aws.kendra.model.SuggestionType]
  type TableCellList = List[zio.aws.kendra.model.TableCell]
  type TableRowList = List[zio.aws.kendra.model.TableRow]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.kendra.model.Tag]
  type Template = software.amazon.awssdk.core.document.Document
  type ThesaurusSummaryItems = List[zio.aws.kendra.model.ThesaurusSummary]
  type UserTokenConfigurationList =
    List[zio.aws.kendra.model.UserTokenConfiguration]
  type ValueImportanceMap = Map[ValueImportanceMapKey, Importance]
  type WarningList = List[zio.aws.kendra.model.Warning]
}
