package zio.aws.keyspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Comment(message: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.Comment = {
    import Comment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.Comment
      .builder()
      .message(message: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.Comment.ReadOnly =
    zio.aws.keyspaces.model.Comment.wrap(buildAwsValue())
}
object Comment {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.keyspaces.model.Comment] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.Comment =
      zio.aws.keyspaces.model.Comment(message)
    def message: String
    def getMessage: ZIO[Any, Nothing, String] = ZIO.succeed(message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.Comment
  ) extends zio.aws.keyspaces.model.Comment.ReadOnly {
    override val message: String = impl.message(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.Comment
  ): zio.aws.keyspaces.model.Comment.ReadOnly = new Wrapper(impl)
}
