package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.GenericString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ClusteringKey(
    name: GenericString,
    orderBy: zio.aws.keyspaces.model.SortOrder
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.ClusteringKey = {
    import ClusteringKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.ClusteringKey
      .builder()
      .name(name: java.lang.String)
      .orderBy(orderBy.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.ClusteringKey.ReadOnly =
    zio.aws.keyspaces.model.ClusteringKey.wrap(buildAwsValue())
}
object ClusteringKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.ClusteringKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.ClusteringKey =
      zio.aws.keyspaces.model.ClusteringKey(name, orderBy)
    def name: GenericString
    def orderBy: zio.aws.keyspaces.model.SortOrder
    def getName: ZIO[Any, Nothing, GenericString] = ZIO.succeed(name)
    def getOrderBy: ZIO[Any, Nothing, zio.aws.keyspaces.model.SortOrder] =
      ZIO.succeed(orderBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.ClusteringKey
  ) extends zio.aws.keyspaces.model.ClusteringKey.ReadOnly {
    override val name: GenericString = impl.name(): GenericString
    override val orderBy: zio.aws.keyspaces.model.SortOrder =
      zio.aws.keyspaces.model.SortOrder.wrap(impl.orderBy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.ClusteringKey
  ): zio.aws.keyspaces.model.ClusteringKey.ReadOnly = new Wrapper(impl)
}
