package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.KeyspaceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateKeyspaceRequest(
    keyspaceName: KeyspaceName,
    tags: Optional[Iterable[zio.aws.keyspaces.model.Tag]] = Optional.Absent,
    replicationSpecification: Optional[
      zio.aws.keyspaces.model.ReplicationSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceRequest = {
    import CreateKeyspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceRequest
      .builder()
      .keyspaceName(KeyspaceName.unwrap(keyspaceName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        replicationSpecification.map(value => value.buildAwsValue())
      )(_.replicationSpecification)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.CreateKeyspaceRequest.ReadOnly =
    zio.aws.keyspaces.model.CreateKeyspaceRequest.wrap(buildAwsValue())
}
object CreateKeyspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.CreateKeyspaceRequest =
      zio.aws.keyspaces.model.CreateKeyspaceRequest(
        keyspaceName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicationSpecification.map(value => value.asEditable)
      )
    def keyspaceName: KeyspaceName
    def tags: Optional[List[zio.aws.keyspaces.model.Tag.ReadOnly]]
    def replicationSpecification
        : Optional[zio.aws.keyspaces.model.ReplicationSpecification.ReadOnly]
    def getKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(keyspaceName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.keyspaces.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getReplicationSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.ReplicationSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicationSpecification",
      replicationSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceRequest
  ) extends zio.aws.keyspaces.model.CreateKeyspaceRequest.ReadOnly {
    override val keyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.keyspaceName())
    override val tags: Optional[List[zio.aws.keyspaces.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.keyspaces.model.Tag.wrap(item)
          }.toList
        )
    override val replicationSpecification
        : Optional[zio.aws.keyspaces.model.ReplicationSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationSpecification())
        .map(value =>
          zio.aws.keyspaces.model.ReplicationSpecification.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceRequest
  ): zio.aws.keyspaces.model.CreateKeyspaceRequest.ReadOnly = new Wrapper(impl)
}
