package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.{TableName, KeyspaceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetTableAutoScalingSettingsRequest(
    keyspaceName: KeyspaceName,
    tableName: TableName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.GetTableAutoScalingSettingsRequest = {
    import GetTableAutoScalingSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.GetTableAutoScalingSettingsRequest
      .builder()
      .keyspaceName(KeyspaceName.unwrap(keyspaceName): java.lang.String)
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.keyspaces.model.GetTableAutoScalingSettingsRequest.ReadOnly =
    zio.aws.keyspaces.model.GetTableAutoScalingSettingsRequest
      .wrap(buildAwsValue())
}
object GetTableAutoScalingSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.GetTableAutoScalingSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.GetTableAutoScalingSettingsRequest =
      zio.aws.keyspaces.model
        .GetTableAutoScalingSettingsRequest(keyspaceName, tableName)
    def keyspaceName: KeyspaceName
    def tableName: TableName
    def getKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(keyspaceName)
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.GetTableAutoScalingSettingsRequest
  ) extends zio.aws.keyspaces.model.GetTableAutoScalingSettingsRequest.ReadOnly {
    override val keyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.keyspaceName())
    override val tableName: TableName =
      zio.aws.keyspaces.model.primitives.TableName(impl.tableName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.GetTableAutoScalingSettingsRequest
  ): zio.aws.keyspaces.model.GetTableAutoScalingSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
